/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mapping.registry;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegisterEvent;
import org.mtr.mapping.holder.Block;
import org.mtr.mapping.holder.Identifier;
import org.mtr.mapping.holder.Item;
import org.mtr.mapping.holder.SoundEvent;
import org.mtr.mapping.mapper.BlockEntityExtension;
import org.mtr.mapping.mapper.BlockItemExtension;
import org.mtr.mapping.mapper.EntityExtension;

public final class ModEventBus {
    final Map<Identifier, Supplier<Block>> BLOCKS = new HashMap<Identifier, Supplier<Block>>();
    final Map<Identifier, Supplier<BlockItemExtension>> BLOCK_ITEMS = new HashMap<Identifier, Supplier<BlockItemExtension>>();
    final Map<Identifier, Supplier<Item>> ITEMS = new HashMap<Identifier, Supplier<Item>>();
    final Map<Identifier, Supplier<BlockEntityType<? extends BlockEntityExtension>>> blockEntityTypes = new HashMap<Identifier, Supplier<BlockEntityType<? extends BlockEntityExtension>>>();
    final Map<Identifier, Supplier<EntityType<? extends EntityExtension>>> entityTypes = new HashMap<Identifier, Supplier<EntityType<? extends EntityExtension>>>();
    final Map<Identifier, Supplier<ParticleType<?>>> particleTypes = new HashMap();
    final Map<Identifier, Supplier<SoundEvent>> soundEvents = new HashMap<Identifier, Supplier<SoundEvent>>();

    @SubscribeEvent
    public void register(RegisterEvent event) {
        event.register(ForgeRegistries.Keys.BLOCKS, helper -> this.BLOCKS.forEach((identifier, supplier) -> helper.register((ResourceLocation)identifier.data, (Object)((net.minecraft.world.level.block.Block)((Block)supplier.get()).data))));
        event.register(ForgeRegistries.Keys.ITEMS, helper -> {
            this.BLOCK_ITEMS.forEach((identifier, supplier) -> helper.register((ResourceLocation)identifier.data, (Object)((net.minecraft.world.item.Item)supplier.get())));
            this.ITEMS.forEach((identifier, supplier) -> helper.register((ResourceLocation)identifier.data, (Object)((net.minecraft.world.item.Item)((Item)supplier.get()).data)));
        });
        event.register(ForgeRegistries.Keys.BLOCK_ENTITY_TYPES, helper -> this.blockEntityTypes.forEach((identifier, supplier) -> helper.register((ResourceLocation)identifier.data, (Object)((BlockEntityType)supplier.get()))));
        event.register(ForgeRegistries.Keys.ENTITY_TYPES, helper -> this.entityTypes.forEach((identifier, supplier) -> helper.register((ResourceLocation)identifier.data, (Object)((EntityType)supplier.get()))));
        event.register(ForgeRegistries.Keys.PARTICLE_TYPES, helper -> this.particleTypes.forEach((identifier, supplier) -> helper.register((ResourceLocation)identifier.data, (Object)((ParticleType)supplier.get()))));
        event.register(ForgeRegistries.Keys.SOUND_EVENTS, helper -> this.soundEvents.forEach((identifier, supplier) -> helper.register((ResourceLocation)identifier.data, (Object)((net.minecraft.sounds.SoundEvent)((SoundEvent)supplier.get()).data))));
    }
}

