/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mapping.render.batch;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.resources.ResourceLocation;
import org.mtr.mapping.holder.Identifier;
import org.mtr.mapping.holder.MinecraftClient;
import org.mtr.mapping.holder.RenderLayer;
import org.mtr.mapping.holder.VertexFormats;
import org.mtr.mapping.mapper.OptimizedModel;
import org.mtr.mapping.mapper.RenderLayerHelper;
import org.mtr.mapping.render.vertex.VertexAttributeState;

public final class MaterialProperties {
    private Identifier texture;
    public final OptimizedModel.ShaderType shaderType;
    public final VertexAttributeState vertexAttributeState;
    public final boolean translucent;
    public final boolean writeDepthBuf;
    public final boolean cutoutHack;
    private static final Function<Identifier, RenderLayer> ENTITY_TRANSLUCENT_CULL = Util.m_143827_(texture -> RenderLayerHelper.createTriangles("entity_translucent_cull_triangles", VertexFormats.getPositionColorTextureOverlayLightNormalMapped(), 256, true, true, RenderLayer.getEntityTranslucentCull(texture)));
    private static final BiFunction<Identifier, Boolean, RenderLayer> BEACON_BEAM = Util.m_143821_((texture, translucent) -> RenderLayerHelper.createTriangles("beacon_beam_triangles", VertexFormats.getPositionColorTextureOverlayLightNormalMapped(), 256, false, translucent, RenderLayer.getBeaconBeam(texture, translucent)));
    private static final Function<Identifier, RenderLayer> ENTITY_CUTOUT = Util.m_143827_(texture -> RenderLayerHelper.createTriangles("entity_cutout_triangles", VertexFormats.getPositionColorTextureOverlayLightNormalMapped(), 256, true, false, RenderLayer.getEntityCutout(texture)));

    public MaterialProperties(OptimizedModel.ShaderType shaderType, Identifier texture, @Nullable Integer color) {
        this.shaderType = shaderType;
        this.texture = texture;
        switch (shaderType) {
            default: {
                this.translucent = false;
                this.writeDepthBuf = true;
                this.cutoutHack = false;
                this.vertexAttributeState = new VertexAttributeState(color, null);
                break;
            }
            case TRANSLUCENT: {
                this.translucent = true;
                this.writeDepthBuf = true;
                this.cutoutHack = false;
                this.vertexAttributeState = new VertexAttributeState(color, null);
                break;
            }
            case CUTOUT_BRIGHT: {
                this.translucent = false;
                this.writeDepthBuf = true;
                this.cutoutHack = false;
                this.vertexAttributeState = new VertexAttributeState(color, 0xF000F0);
                break;
            }
            case TRANSLUCENT_BRIGHT: {
                this.translucent = true;
                this.writeDepthBuf = true;
                this.cutoutHack = false;
                this.vertexAttributeState = new VertexAttributeState(color, 0xF000F0);
                break;
            }
            case CUTOUT_GLOWING: {
                this.translucent = false;
                this.writeDepthBuf = true;
                this.cutoutHack = true;
                this.vertexAttributeState = new VertexAttributeState(color, null);
                break;
            }
            case TRANSLUCENT_GLOWING: {
                this.translucent = true;
                this.writeDepthBuf = false;
                this.cutoutHack = false;
                this.vertexAttributeState = new VertexAttributeState(color, null);
            }
        }
    }

    public void setupCompositeState() {
        RenderSystem.m_157456_((int)0, (ResourceLocation)((ResourceLocation)this.texture.data));
        if (this.translucent || this.cutoutHack) {
            RenderSystem.m_69478_();
            RenderSystem.m_69416_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        } else {
            RenderSystem.m_69461_();
        }
        RenderSystem.m_69482_();
        RenderSystem.m_69456_((int)515);
        RenderSystem.m_69481_();
        MinecraftClient.getInstance().getGameRendererMapped().getLightmapTextureManager().enable();
        MinecraftClient.getInstance().getGameRendererMapped().getOverlayTexture().setupOverlayColor();
        RenderSystem.m_69458_((boolean)this.writeDepthBuf);
    }

    public RenderLayer getBlazeRenderType() {
        switch (this.shaderType) {
            case TRANSLUCENT: 
            case TRANSLUCENT_BRIGHT: {
                return ENTITY_TRANSLUCENT_CULL.apply(this.texture);
            }
            case CUTOUT_GLOWING: 
            case TRANSLUCENT_GLOWING: {
                return BEACON_BEAM.apply(this.texture, this.translucent);
            }
        }
        return ENTITY_CUTOUT.apply(this.texture);
    }

    public Identifier getTexture() {
        return this.texture;
    }

    public void setTexture(Identifier texture) {
        this.texture = texture;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof MaterialProperties)) {
            return false;
        }
        MaterialProperties materialProperties = (MaterialProperties)object;
        return this.shaderType == materialProperties.shaderType && Objects.equals(this.texture, materialProperties.texture) && Objects.equals(this.vertexAttributeState, materialProperties.vertexAttributeState) && this.translucent == materialProperties.translucent && this.writeDepthBuf == materialProperties.writeDepthBuf && this.cutoutHack == materialProperties.cutoutHack;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.shaderType, this.texture, this.vertexAttributeState, this.translucent, this.writeDepthBuf, this.cutoutHack});
    }
}

