/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mapping.render.shader;

import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.blaze3d.vertex.VertexFormatElement;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.server.packs.resources.ResourceProvider;
import org.mtr.mapping.holder.Matrix4f;
import org.mtr.mapping.holder.MinecraftClient;
import org.mtr.mapping.holder.Window;
import org.mtr.mapping.mapper.OptimizedModel;
import org.mtr.mapping.render.batch.MaterialProperties;
import org.mtr.mapping.render.shader.PatchingResourceProvider;
import org.mtr.mapping.render.tool.Utilities;
import org.mtr.mapping.tool.DummyClass;

public final class ShaderManager {
    private final Map<String, ShaderInstance> shaders = new HashMap<String, ShaderInstance>();
    private static final VertexFormatElement MINECRAFT_ELEMENT_MATRIX = new VertexFormatElement(0, VertexFormatElement.Type.FLOAT, VertexFormatElement.Usage.GENERIC, 16);
    private static final VertexFormat MINECRAFT_VERTEX_FORMAT_BLOCK = new VertexFormat(ImmutableMap.builder().put((Object)"Position", (Object)DefaultVertexFormat.f_85804_).put((Object)"Color", (Object)DefaultVertexFormat.f_85805_).put((Object)"UV0", (Object)DefaultVertexFormat.f_85806_).put((Object)"UV1", (Object)DefaultVertexFormat.f_85807_).put((Object)"UV2", (Object)DefaultVertexFormat.f_85808_).put((Object)"Normal", (Object)DefaultVertexFormat.f_85809_).put((Object)"ModelMat", (Object)MINECRAFT_ELEMENT_MATRIX).put((Object)"Padding", (Object)DefaultVertexFormat.f_85810_).build());

    public boolean isReady() {
        return !this.shaders.isEmpty();
    }

    public void reloadShaders() {
        this.shaders.values().forEach(ShaderInstance::close);
        this.shaders.clear();
        PatchingResourceProvider patchingResourceProvider = new PatchingResourceProvider(MinecraftClient.getInstance().getResourceManager());
        this.loadShader(patchingResourceProvider, ShaderManager.getShaderName(OptimizedModel.ShaderType.CUTOUT));
        this.loadShader(patchingResourceProvider, ShaderManager.getShaderName(OptimizedModel.ShaderType.TRANSLUCENT));
        this.loadShader(patchingResourceProvider, ShaderManager.getShaderName(OptimizedModel.ShaderType.CUTOUT_GLOWING));
    }

    private void loadShader(PatchingResourceProvider resourceManager, String shaderName) {
        try {
            this.shaders.put(shaderName, new ShaderInstance((ResourceProvider)resourceManager, shaderName, MINECRAFT_VERTEX_FORMAT_BLOCK));
        }
        catch (Exception e) {
            DummyClass.logException(e);
        }
    }

    public void setupShaderBatchState(MaterialProperties materialProperties) {
        ShaderInstance shaderProgram;
        if (Utilities.canUseCustomShader()) {
            shaderProgram = this.shaders.get(ShaderManager.getShaderName(materialProperties.shaderType));
            materialProperties.setupCompositeState();
        } else {
            materialProperties.getBlazeRenderType().startDrawing();
            shaderProgram = RenderSystem.m_157196_();
        }
        if (shaderProgram == null) {
            throw new IllegalArgumentException("Cannot get shader: " + materialProperties.shaderType);
        }
        for (int i = 0; i < 8; ++i) {
            shaderProgram.m_173350_("Sampler" + i, (Object)RenderSystem.m_157203_((int)i));
        }
        if (shaderProgram.f_173308_ != null) {
            shaderProgram.f_173308_.m_5679_((com.mojang.math.Matrix4f)Utilities.copy((Matrix4f)new Matrix4f((com.mojang.math.Matrix4f)RenderSystem.m_157190_())).data);
        }
        if (shaderProgram.f_173309_ != null) {
            shaderProgram.f_173309_.m_5679_(RenderSystem.m_157192_());
        }
        if (shaderProgram.f_200956_ != null) {
            shaderProgram.f_200956_.m_200759_(RenderSystem.m_200906_());
        }
        if (shaderProgram.f_173312_ != null) {
            shaderProgram.f_173312_.m_5941_(RenderSystem.m_157197_());
        }
        if (shaderProgram.f_173315_ != null) {
            shaderProgram.f_173315_.m_5985_(RenderSystem.m_157200_());
        }
        if (shaderProgram.f_173316_ != null) {
            shaderProgram.f_173316_.m_5985_(RenderSystem.m_157199_());
        }
        if (shaderProgram.f_173317_ != null) {
            shaderProgram.f_173317_.m_5941_(RenderSystem.m_157198_());
        }
        if (shaderProgram.f_202432_ != null) {
            shaderProgram.f_202432_.m_142617_(RenderSystem.m_202041_().m_202324_());
        }
        if (shaderProgram.f_173310_ != null) {
            shaderProgram.f_173310_.m_5679_(RenderSystem.m_157207_());
        }
        if (shaderProgram.f_173319_ != null) {
            shaderProgram.f_173319_.m_5985_(RenderSystem.m_157201_());
        }
        if (shaderProgram.f_173311_ != null) {
            Window window = MinecraftClient.getInstance().getWindow();
            shaderProgram.f_173311_.m_142326_(window.getWidth(), window.getHeight());
        }
        RenderSystem.m_157461_((ShaderInstance)shaderProgram);
        shaderProgram.m_173363_();
    }

    public void cleanupShaderBatchState() {
        ShaderInstance shaderProgram;
        if (!Utilities.canUseCustomShader() && (shaderProgram = RenderSystem.m_157196_()) != null && shaderProgram.f_173308_ != null) {
            shaderProgram.f_173308_.m_5679_(RenderSystem.m_157190_());
            shaderProgram.m_173363_();
        }
    }

    private static String getShaderName(OptimizedModel.ShaderType shaderType) {
        switch (shaderType) {
            default: {
                return "rendertype_entity_cutout";
            }
            case TRANSLUCENT: 
            case TRANSLUCENT_BRIGHT: {
                return "rendertype_entity_translucent_cull";
            }
            case CUTOUT_GLOWING: 
            case TRANSLUCENT_GLOWING: 
        }
        return "rendertype_beacon_beam";
    }
}

