/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mod.item;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.mtr.core.data.Rail;
import org.mtr.core.data.TransportMode;
import org.mtr.core.tool.Angle;
import org.mtr.mapping.holder.ActionResult;
import org.mtr.mapping.holder.Block;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.BlockState;
import org.mtr.mapping.holder.CompoundTag;
import org.mtr.mapping.holder.ItemSettings;
import org.mtr.mapping.holder.ItemStack;
import org.mtr.mapping.holder.ItemUsageContext;
import org.mtr.mapping.holder.MutableText;
import org.mtr.mapping.holder.PlayerEntity;
import org.mtr.mapping.holder.ServerPlayerEntity;
import org.mtr.mapping.holder.TextFormatting;
import org.mtr.mapping.holder.TooltipContext;
import org.mtr.mapping.holder.World;
import org.mtr.mapping.mapper.TextHelper;
import org.mtr.mod.Blocks;
import org.mtr.mod.InitClient;
import org.mtr.mod.block.BlockNode;
import org.mtr.mod.generated.lang.TranslationProvider;
import org.mtr.mod.item.ItemNodeModifierBase;

public abstract class ItemNodeModifierSelectableBlockBase
extends ItemNodeModifierBase {
    private final boolean canSaveBlock;
    private final int height;
    private final int width;
    private final int radius;
    private static final String TAG_BLOCK_ID = "block_id";

    public ItemNodeModifierSelectableBlockBase(boolean canSaveBlock, int height, int width, ItemSettings itemSettings) {
        super(true, false, false, true, itemSettings);
        this.canSaveBlock = canSaveBlock;
        this.height = height;
        this.width = width;
        this.radius = width / 2;
    }

    @Override
    @Nonnull
    public ActionResult useOnBlock2(ItemUsageContext context) {
        PlayerEntity playerEntity;
        World world;
        if (this.canSaveBlock && !(world = context.getWorld()).isClient() && (playerEntity = context.getPlayer()) != null && playerEntity.isSneaking()) {
            BlockState state = world.getBlockState(context.getBlockPos());
            BlockState neighborState = state.getBlock().data instanceof BlockNode ? org.mtr.mapping.holder.Blocks.getAirMapped().getDefaultState() : state;
            playerEntity.sendMessage(TranslationProvider.TOOLTIP_MTR_SELECTED_MATERIAL.getText(TextHelper.translatable(neighborState.getBlock().getTranslationKey(), new Object[0]).getString()), true);
            CompoundTag compoundTag = context.getStack().getOrCreateTag();
            compoundTag.putInt(TAG_BLOCK_ID, Block.getRawIdFromState(neighborState));
            return ActionResult.SUCCESS;
        }
        return super.useOnBlock2(context);
    }

    @Override
    public void addTooltips(ItemStack stack, @Nullable World world, List<MutableText> tooltip, TooltipContext options) {
        if (this.height > 0) {
            tooltip.add(TranslationProvider.TOOLTIP_MTR_RAIL_ACTION_HEIGHT.getMutableText(this.height).formatted(TextFormatting.GRAY));
        }
        tooltip.add(TranslationProvider.TOOLTIP_MTR_RAIL_ACTION_WIDTH.getMutableText(this.width).formatted(TextFormatting.GRAY));
        if (this.canSaveBlock) {
            String[] textSplit;
            BlockState state = this.getSavedState(stack);
            for (String text : textSplit = (state.isAir() ? TranslationProvider.TOOLTIP_MTR_SHIFT_RIGHT_CLICK_TO_SELECT_MATERIAL : TranslationProvider.TOOLTIP_MTR_SHIFT_RIGHT_CLICK_TO_CLEAR).getString(InitClient.getShiftText(), TextHelper.translatable((String)Blocks.RAIL_NODE.get().getTranslationKey(), (Object[])new Object[0]).data).split("\\|")) {
                tooltip.add(TextHelper.literal(text).formatted(TextFormatting.GRAY).formatted(TextFormatting.ITALIC));
            }
            tooltip.add(TranslationProvider.TOOLTIP_MTR_SELECTED_MATERIAL.getMutableText(TextHelper.translatable(state.getBlock().getTranslationKey(), new Object[0]).getString()).formatted(TextFormatting.GREEN));
        }
        super.addTooltips(stack, world, tooltip, options);
    }

    @Override
    protected final void onConnect(World world, ItemStack itemStack, TransportMode transportMode, BlockState stateStart, BlockState stateEnd, BlockPos posStart, BlockPos posEnd, Angle facingStart, Angle facingEnd, @Nullable ServerPlayerEntity serverPlayerEntity) {
        if (serverPlayerEntity != null) {
            ItemNodeModifierSelectableBlockBase.getRail(world, posStart, posEnd, serverPlayerEntity, rail -> this.onConnect((Rail)rail, serverPlayerEntity, itemStack, this.radius, this.height));
        }
    }

    @Override
    protected final void onRemove(World world, BlockPos posStart, BlockPos posEnd, @Nullable ServerPlayerEntity serverPlayerEntity) {
    }

    protected BlockState getSavedState(ItemStack stack) {
        CompoundTag tag = stack.getOrCreateTag();
        if (tag.contains(TAG_BLOCK_ID)) {
            return Block.getStateFromRawId(tag.getInt(TAG_BLOCK_ID));
        }
        return org.mtr.mapping.holder.Blocks.getAirMapped().getDefaultState();
    }

    protected abstract void onConnect(Rail var1, ServerPlayerEntity var2, ItemStack var3, int var4, int var5);
}

