/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mod.sound;

import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Vec3i;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.ClientPlayerEntity;
import org.mtr.mapping.holder.Identifier;
import org.mtr.mapping.holder.MathHelper;
import org.mtr.mapping.holder.MinecraftClient;
import org.mtr.mapping.holder.SoundCategory;
import org.mtr.mapping.holder.SoundManager;
import org.mtr.mapping.holder.Vector3i;
import org.mtr.mapping.mapper.AbstractSoundInstanceExtension;
import org.mtr.mapping.mapper.SoundHelper;
import org.mtr.mapping.mapper.TickableSoundInstanceExtension;

public class LoopingSoundInstance
extends AbstractSoundInstanceExtension
implements TickableSoundInstanceExtension {
    private static final int MAX_DISTANCE = 32;

    public LoopingSoundInstance(String soundId) {
        super(SoundHelper.createSoundEvent(new Identifier("mtr", soundId)), SoundCategory.getBlocksMapped());
        this.setIsRepeatableMapped(true);
    }

    @Override
    public boolean isDone() {
        return false;
    }

    @Override
    public void tick2() {
    }

    public void setPos(BlockPos blockPos, boolean isRemoved) {
        if (isRemoved) {
            if (this.getXMapped() == (double)blockPos.getX() && this.getYMapped() == (double)blockPos.getY() && this.getZMapped() == (double)blockPos.getZ()) {
                this.setXMapped(0.0);
                this.setYMapped(2.147483647E9);
                this.setZMapped(0.0);
            }
        } else {
            ClientPlayerEntity clientPlayerEntity = MinecraftClient.getInstance().getPlayerMapped();
            if (clientPlayerEntity == null) {
                return;
            }
            BlockPos playerPos = clientPlayerEntity.getBlockPos();
            int distance = playerPos.getManhattanDistance(new Vector3i((Vec3i)blockPos.data));
            if (distance <= 32) {
                SoundManager soundManager;
                int currentDistance = playerPos.getManhattanDistance(new Vector3i(MathHelper.floor(this.getXMapped()), MathHelper.floor(this.getYMapped()), MathHelper.floor(this.getZMapped())));
                if (distance < currentDistance) {
                    this.setXMapped(blockPos.getX());
                    this.setYMapped(blockPos.getY());
                    this.setZMapped(blockPos.getZ());
                }
                if (!(soundManager = MinecraftClient.getInstance().getSoundManager()).isPlaying(new org.mtr.mapping.holder.SoundInstance((SoundInstance)this))) {
                    soundManager.play(new org.mtr.mapping.holder.SoundInstance((SoundInstance)this));
                }
            }
        }
    }
}

