/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mod.model;

import org.mtr.mapping.holder.OverlayTexture;
import org.mtr.mapping.mapper.GraphicsHolder;
import org.mtr.mapping.mapper.ModelPartExtension;
import org.mtr.mod.client.DoorAnimationType;
import org.mtr.mod.model.ModelTrainBase;
import org.mtr.mod.resource.RenderStage;

public class ModelLift1
extends ModelTrainBase {
    private final ModelPartExtension main;
    private final ModelPartExtension main_ceiling;
    private final ModelPartExtension main_edge;
    private final ModelPartExtension main_edge_wall;
    private final ModelPartExtension main_edge_ceiling;
    private final ModelPartExtension main_corner;
    private final ModelPartExtension main_corner_wall;
    private final ModelPartExtension main_corner_ceiling;
    private final ModelPartExtension main_exterior;
    private final ModelPartExtension main_exterior_ceiling;
    private final ModelPartExtension main_exterior_edge;
    private final ModelPartExtension main_exterior_edge_ceiling;
    private final ModelPartExtension main_exterior_corner;
    private final ModelPartExtension main_exterior_corner_wall;
    private final ModelPartExtension main_exterior_corner_ceiling;
    private final ModelPartExtension main_light;
    private final ModelPartExtension door;
    private final ModelPartExtension door_left;
    private final ModelPartExtension door_right;
    private final ModelPartExtension door_wall;
    private final ModelPartExtension door_ceiling;
    private final ModelPartExtension door_exterior;
    private final ModelPartExtension door_left_exterior;
    private final ModelPartExtension door_right_exterior;
    private final ModelPartExtension door_wall_exterior;
    private final ModelPartExtension door_ceiling_exterior;
    private final ModelPartExtension wall_patch;
    private final ModelPartExtension wall_patch_wall;
    private final int heightCount;
    private final int heightOffset;
    private final int width;
    private final int depth;
    private final boolean isDoubleSided;

    public ModelLift1(int height, int width, int depth, boolean isDoubleSided) {
        super(128, 128, DoorAnimationType.CONSTANT, false);
        this.heightCount = height - 4;
        this.heightOffset = -this.heightCount * 8;
        this.width = width;
        this.depth = depth;
        this.isDoubleSided = isDoubleSided;
        this.main = this.createModelPart();
        this.main.setPivot(0.0f, 24.0f, 0.0f);
        this.main.setTextureUVOffset(0, 34).addCuboid(-8.0f, 0.0f, -8.0f, 16, 0, 16, 0.0f, false);
        this.main_ceiling = this.createModelPart();
        this.main_ceiling.setPivot(0.0f, 24.0f, 0.0f);
        this.main_ceiling.setTextureUVOffset(79, 44).addCuboid(-8.0f, -32.0f, -8.0f, 16, 0, 16, 0.0f, false);
        this.main_edge = this.createModelPart();
        this.main_edge.setPivot(0.0f, 24.0f, 0.0f);
        this.main_edge.setTextureUVOffset(18, 44).addCuboid(-4.0f, 0.0f, -8.0f, 8, 0, 6, 0.0f, false);
        this.main_edge.setTextureUVOffset(76, 33).addCuboid(-4.0f, -32.0f, -3.0f, 8, 32, 1, 0.0f, false);
        this.main_edge.setTextureUVOffset(28, 52).addCuboid(-4.0f, -13.0f, -4.0f, 8, 1, 1, 0.0f, false);
        this.main_edge.setTextureUVOffset(26, 50).addCuboid(-4.0f, -2.0f, -4.0f, 8, 1, 1, 0.0f, false);
        this.main_edge_wall = this.createModelPart();
        this.main_edge_wall.setPivot(0.0f, 24.0f, 0.0f);
        this.main_edge_wall.setTextureUVOffset(76, 33).addCuboid(-4.0f, -40.0f, -3.0f, 8, 8, 1, 0.0f, false);
        this.main_edge_ceiling = this.createModelPart();
        this.main_edge_ceiling.setPivot(0.0f, 24.0f, 0.0f);
        this.main_edge_ceiling.setTextureUVOffset(97, 44).addCuboid(-4.0f, -32.0f, -8.0f, 8, 0, 6, 0.0f, false);
        this.main_corner = this.createModelPart();
        this.main_corner.setPivot(0.0f, 24.0f, 0.0f);
        this.main_corner.setTextureUVOffset(20, 44).addCuboid(2.0f, 0.0f, -8.0f, 6, 0, 6, 0.0f, false);
        this.main_corner.setTextureUVOffset(112, 62).addCuboid(3.0f, -32.0f, -3.0f, 5, 32, 1, 0.0f, false);
        this.main_corner.setTextureUVOffset(29, 52).addCuboid(5.0f, -13.0f, -4.0f, 3, 1, 1, 0.0f, false);
        this.main_corner.setTextureUVOffset(27, 50).addCuboid(5.0f, -2.0f, -4.0f, 3, 1, 1, 0.0f, false);
        this.main_corner.setTextureUVOffset(104, 68).addCuboid(2.0f, -32.0f, -3.0f, 1, 32, 1, 0.0f, false);
        ModelPartExtension handrail_bottom_r1 = this.main_corner.addChild();
        handrail_bottom_r1.setPivot(0.0f, 0.0f, 0.0f);
        ModelLift1.setRotationAngle(handrail_bottom_r1, 0.0f, -1.5708f, 0.0f);
        handrail_bottom_r1.setTextureUVOffset(36, 50).addCuboid(-8.0f, -2.0f, -4.0f, 3, 1, 1, 0.0f, false);
        handrail_bottom_r1.setTextureUVOffset(38, 52).addCuboid(-8.0f, -13.0f, -4.0f, 3, 1, 1, 0.0f, false);
        handrail_bottom_r1.setTextureUVOffset(112, 62).addCuboid(-8.0f, -32.0f, -3.0f, 5, 32, 1, 0.0f, false);
        this.main_corner_wall = this.createModelPart();
        this.main_corner_wall.setPivot(0.0f, 24.0f, 0.0f);
        this.main_corner_wall.setTextureUVOffset(112, 62).addCuboid(3.0f, -40.0f, -3.0f, 5, 8, 1, 0.0f, false);
        this.main_corner_wall.setTextureUVOffset(104, 68).addCuboid(2.0f, -40.0f, -3.0f, 1, 8, 1, 0.0f, false);
        ModelPartExtension wall_r1 = this.main_corner_wall.addChild();
        wall_r1.setPivot(0.0f, 0.0f, 0.0f);
        ModelLift1.setRotationAngle(wall_r1, 0.0f, -1.5708f, 0.0f);
        wall_r1.setTextureUVOffset(112, 62).addCuboid(-8.0f, -40.0f, -3.0f, 5, 8, 1, 0.0f, false);
        this.main_corner_ceiling = this.createModelPart();
        this.main_corner_ceiling.setPivot(0.0f, 24.0f, 0.0f);
        this.main_corner_ceiling.setTextureUVOffset(99, 44).addCuboid(2.0f, -32.0f, -8.0f, 6, 0, 6, 0.0f, false);
        this.main_exterior = this.createModelPart();
        this.main_exterior.setPivot(0.0f, 24.0f, 0.0f);
        this.main_exterior.setTextureUVOffset(0, 17).addCuboid(-8.0f, 0.0f, -8.0f, 16, 1, 16, 0.0f, false);
        this.main_exterior_ceiling = this.createModelPart();
        this.main_exterior_ceiling.setPivot(0.0f, 24.0f, 0.0f);
        this.main_exterior_ceiling.setTextureUVOffset(0, 0).addCuboid(-8.0f, -33.0f, -8.0f, 16, 1, 16, 0.0f, false);
        this.main_exterior_edge = this.createModelPart();
        this.main_exterior_edge.setPivot(0.0f, 24.0f, 0.0f);
        this.main_exterior_edge.setTextureUVOffset(18, 27).addCuboid(-4.0f, 0.0f, -8.0f, 8, 1, 6, 0.0f, false);
        this.main_exterior_edge_ceiling = this.createModelPart();
        this.main_exterior_edge_ceiling.setPivot(0.0f, 24.0f, 0.0f);
        this.main_exterior_edge_ceiling.setTextureUVOffset(18, 10).addCuboid(-4.0f, -33.0f, -8.0f, 8, 1, 6, 0.0f, false);
        this.main_exterior_corner = this.createModelPart();
        this.main_exterior_corner.setPivot(0.0f, 24.0f, 0.0f);
        this.main_exterior_corner.setTextureUVOffset(20, 27).addCuboid(2.0f, 0.0f, -8.0f, 6, 1, 6, 0.0f, false);
        this.main_exterior_corner_wall = this.createModelPart();
        this.main_exterior_corner_wall.setPivot(0.0f, 24.0f, 0.0f);
        this.main_exterior_corner_wall.setTextureUVOffset(108, 68).addCuboid(2.0f, -40.0f, -3.0f, 1, 8, 1, 0.0f, false);
        this.main_exterior_corner_ceiling = this.createModelPart();
        this.main_exterior_corner_ceiling.setPivot(0.0f, 24.0f, 0.0f);
        this.main_exterior_corner_ceiling.setTextureUVOffset(20, 10).addCuboid(2.0f, -33.0f, -8.0f, 6, 1, 6, 0.0f, false);
        this.main_light = this.createModelPart();
        this.main_light.setPivot(0.0f, 24.0f, 0.0f);
        this.main_light.setTextureUVOffset(79, 28).addCuboid(-8.0f, -32.5f, -8.0f, 16, 0, 16, 0.0f, false);
        this.door = this.createModelPart();
        this.door.setPivot(0.0f, 24.0f, 0.0f);
        this.door.setTextureUVOffset(90, 66).addCuboid(-16.0f, -32.0f, 4.0f, 4, 32, 3, 0.0f, false);
        this.door.setTextureUVOffset(14, 84).addCuboid(12.0f, -32.0f, 4.0f, 4, 32, 3, 0.0f, false);
        this.door.setTextureUVOffset(20, 101).addCuboid(-16.0f, 0.0f, 0.0f, 32, 0, 8, 0.0f, false);
        this.door_left = this.createModelPart();
        this.door_left.setPivot(0.0f, 24.0f, 0.0f);
        this.door_left.setTextureUVOffset(52, 68).addCuboid(-12.0f, -32.0f, 6.0f, 12, 32, 0, 0.0f, false);
        this.door_right = this.createModelPart();
        this.door_right.setPivot(0.0f, 24.0f, 0.0f);
        this.door_right.setTextureUVOffset(28, 68).addCuboid(0.0f, -32.0f, 6.0f, 12, 32, 0, 0.0f, false);
        this.door_wall = this.createModelPart();
        this.door_wall.setPivot(0.0f, 24.0f, 0.0f);
        this.door_wall.setTextureUVOffset(48, 0).addCuboid(-16.0f, -40.0f, 4.0f, 32, 8, 3, 0.0f, false);
        this.door_ceiling = this.createModelPart();
        this.door_ceiling.setPivot(0.0f, 24.0f, 0.0f);
        this.door_ceiling.setTextureUVOffset(20, 101).addCuboid(-16.0f, -32.0f, 0.0f, 32, 0, 8, 0.0f, false);
        this.door_exterior = this.createModelPart();
        this.door_exterior.setPivot(0.0f, 24.0f, 0.0f);
        this.door_exterior.setTextureUVOffset(0, 84).addCuboid(-16.0f, -32.0f, 4.0f, 4, 32, 3, 0.0f, false);
        this.door_exterior.setTextureUVOffset(76, 66).addCuboid(12.0f, -32.0f, 4.0f, 4, 32, 3, 0.0f, false);
        this.door_exterior.setTextureUVOffset(28, 109).addCuboid(-16.0f, 0.0f, 0.0f, 32, 1, 8, 0.0f, false);
        this.door_left_exterior = this.createModelPart();
        this.door_left_exterior.setPivot(0.0f, 24.0f, 0.0f);
        this.door_left_exterior.setTextureUVOffset(0, 50).addCuboid(-12.0f, -32.0f, 6.0f, 12, 32, 2, 0.0f, false);
        this.door_right_exterior = this.createModelPart();
        this.door_right_exterior.setPivot(0.0f, 24.0f, 0.0f);
        this.door_right_exterior.setTextureUVOffset(48, 34).addCuboid(0.0f, -32.0f, 6.0f, 12, 32, 2, 0.0f, false);
        this.door_wall_exterior = this.createModelPart();
        this.door_wall_exterior.setPivot(0.0f, 24.0f, 0.0f);
        this.door_wall_exterior.setTextureUVOffset(48, 17).addCuboid(-16.0f, -40.0f, 5.0f, 32, 8, 3, 0.0f, false);
        this.door_ceiling_exterior = this.createModelPart();
        this.door_ceiling_exterior.setPivot(0.0f, 24.0f, 0.0f);
        this.door_ceiling_exterior.setTextureUVOffset(0, 119).addCuboid(-16.0f, -33.0f, 0.0f, 32, 1, 8, 0.0f, false);
        this.wall_patch = this.createModelPart();
        this.wall_patch.setPivot(0.0f, 24.0f, 0.0f);
        ModelPartExtension wall_r2 = this.wall_patch.addChild();
        wall_r2.setPivot(0.0f, 0.0f, 0.0f);
        ModelLift1.setRotationAngle(wall_r2, 0.0f, -1.5708f, 0.0f);
        wall_r2.setTextureUVOffset(108, 95).addCuboid(0.0f, -32.0f, 13.0f, 4, 32, 1, 0.0f, false);
        wall_r2.setTextureUVOffset(30, 50).addCuboid(0.0f, -2.0f, 12.0f, 4, 1, 1, 0.0f, false);
        wall_r2.setTextureUVOffset(32, 52).addCuboid(0.0f, -13.0f, 12.0f, 4, 1, 1, 0.0f, false);
        ModelPartExtension wall_r3 = this.wall_patch.addChild();
        wall_r3.setPivot(0.0f, 0.0f, 0.0f);
        ModelLift1.setRotationAngle(wall_r3, 0.0f, 1.5708f, 0.0f);
        wall_r3.setTextureUVOffset(108, 95).addCuboid(-4.0f, -32.0f, 13.0f, 4, 32, 1, 0.0f, false);
        wall_r3.setTextureUVOffset(30, 50).addCuboid(-4.0f, -2.0f, 12.0f, 4, 1, 1, 0.0f, false);
        wall_r3.setTextureUVOffset(32, 52).addCuboid(-4.0f, -13.0f, 12.0f, 4, 1, 1, 0.0f, false);
        this.wall_patch_wall = this.createModelPart();
        this.wall_patch_wall.setPivot(0.0f, 24.0f, 0.0f);
        ModelPartExtension wall_r4 = this.wall_patch_wall.addChild();
        wall_r4.setPivot(0.0f, 0.0f, 0.0f);
        ModelLift1.setRotationAngle(wall_r4, 0.0f, -1.5708f, 0.0f);
        wall_r4.setTextureUVOffset(108, 95).addCuboid(0.0f, -40.0f, 13.0f, 4, 8, 1, 0.0f, false);
        ModelPartExtension wall_r5 = this.wall_patch_wall.addChild();
        wall_r5.setPivot(0.0f, 0.0f, 0.0f);
        ModelLift1.setRotationAngle(wall_r5, 0.0f, 1.5708f, 0.0f);
        wall_r5.setTextureUVOffset(108, 95).addCuboid(-4.0f, -40.0f, 13.0f, 4, 8, 1, 0.0f, false);
        this.buildModel();
    }

    @Override
    protected void render(GraphicsHolder graphicsHolder, RenderStage renderStage, int light, float doorLeftX, float doorRightX, float doorLeftZ, float doorRightZ, int currentCar, int trainCars, boolean head1IsFront, boolean renderDetails) {
        for (int i = 0; i <= this.width; ++i) {
            block5: for (int j = 0; j <= this.depth; ++j) {
                float x = ((float)i - (float)this.width / 2.0f) * 16.0f;
                float z = ((float)j - (float)this.depth / 2.0f) * 16.0f;
                boolean edge1X = i == 0;
                boolean edge2X = i == this.width;
                boolean edge1Z = j == 0;
                boolean edge2Z = j == this.depth;
                switch (renderStage) {
                    case LIGHT: {
                        if (edge1X || edge2X || edge1Z || edge2Z) continue block5;
                        ModelTrainBase.renderOnce(this.main_light, graphicsHolder, light, x, this.heightOffset, z);
                        continue block5;
                    }
                    case INTERIOR: 
                    case EXTERIOR: {
                        ModelPartExtension mainCornerCeilingPiece;
                        ModelPartExtension mainPiece = renderStage == RenderStage.INTERIOR ? this.main : this.main_exterior;
                        ModelPartExtension mainCeilingPiece = renderStage == RenderStage.INTERIOR ? this.main_ceiling : this.main_exterior_ceiling;
                        ModelPartExtension mainEdgePiece = renderStage == RenderStage.INTERIOR ? this.main_edge : this.main_exterior_edge;
                        ModelPartExtension mainEdgeCeilingPiece = renderStage == RenderStage.INTERIOR ? this.main_edge_ceiling : this.main_exterior_edge_ceiling;
                        ModelPartExtension mainCornerPiece = renderStage == RenderStage.INTERIOR ? this.main_corner : this.main_exterior_corner;
                        ModelPartExtension mainCornerWallPiece = renderStage == RenderStage.INTERIOR ? this.main_corner_wall : this.main_exterior_corner_wall;
                        ModelPartExtension modelPartExtension = mainCornerCeilingPiece = renderStage == RenderStage.INTERIOR ? this.main_corner_ceiling : this.main_exterior_corner_ceiling;
                        if (!(edge1X || edge2X || edge1Z || edge2Z)) {
                            ModelTrainBase.renderOnce(mainPiece, graphicsHolder, light, x, z);
                            ModelTrainBase.renderOnce(mainCeilingPiece, graphicsHolder, light, x, this.heightOffset, z);
                        }
                        if (edge1X && !edge2X && !edge1Z && !edge2Z) {
                            mainEdgePiece.render(graphicsHolder, x, z - 4.0f, -1.5707964f, light, OverlayTexture.getDefaultUvMapped());
                            mainEdgePiece.render(graphicsHolder, x, z + 4.0f, -1.5707964f, light, OverlayTexture.getDefaultUvMapped());
                            if (renderStage == RenderStage.INTERIOR) {
                                this.renderWall(this.main_edge_wall, graphicsHolder, x, z - 4.0f, -1.5707964f, light);
                                this.renderWall(this.main_edge_wall, graphicsHolder, x, z + 4.0f, -1.5707964f, light);
                            }
                            mainEdgeCeilingPiece.render(graphicsHolder, x, this.heightOffset, z - 4.0f, -1.5707964f, light, OverlayTexture.getDefaultUvMapped());
                            mainEdgeCeilingPiece.render(graphicsHolder, x, this.heightOffset, z + 4.0f, -1.5707964f, light, OverlayTexture.getDefaultUvMapped());
                        }
                        if (!edge1X && edge2X && !edge1Z && !edge2Z) {
                            mainEdgePiece.render(graphicsHolder, x, z - 4.0f, 1.5707964f, light, OverlayTexture.getDefaultUvMapped());
                            mainEdgePiece.render(graphicsHolder, x, z + 4.0f, 1.5707964f, light, OverlayTexture.getDefaultUvMapped());
                            if (renderStage == RenderStage.INTERIOR) {
                                this.renderWall(this.main_edge_wall, graphicsHolder, x, z - 4.0f, 1.5707964f, light);
                                this.renderWall(this.main_edge_wall, graphicsHolder, x, z + 4.0f, 1.5707964f, light);
                            }
                            mainEdgeCeilingPiece.render(graphicsHolder, x, this.heightOffset, z - 4.0f, 1.5707964f, light, OverlayTexture.getDefaultUvMapped());
                            mainEdgeCeilingPiece.render(graphicsHolder, x, this.heightOffset, z + 4.0f, 1.5707964f, light, OverlayTexture.getDefaultUvMapped());
                        }
                        if (!(edge1X || edge2X || edge1Z || !edge2Z || this.isDoubleSided)) {
                            ModelTrainBase.renderOnce(mainEdgePiece, graphicsHolder, light, x - 4.0f, z);
                            ModelTrainBase.renderOnce(mainEdgePiece, graphicsHolder, light, x + 4.0f, z);
                            if (renderStage == RenderStage.INTERIOR) {
                                this.renderWallOnce(this.main_edge_wall, graphicsHolder, x - 4.0f, z, light);
                                this.renderWallOnce(this.main_edge_wall, graphicsHolder, x + 4.0f, z, light);
                            }
                            ModelTrainBase.renderOnce(mainEdgeCeilingPiece, graphicsHolder, light, x - 4.0f, this.heightOffset, z);
                            ModelTrainBase.renderOnce(mainEdgeCeilingPiece, graphicsHolder, light, x + 4.0f, this.heightOffset, z);
                        }
                        if (!(!edge1X || edge2X || edge1Z || !edge2Z || this.width <= 2 && this.isDoubleSided)) {
                            mainCornerPiece.render(graphicsHolder, x, z, 0.0f, light, OverlayTexture.getDefaultUvMapped());
                            if (renderStage == RenderStage.INTERIOR) {
                                this.renderWall(mainCornerWallPiece, graphicsHolder, x, z, 0.0f, light);
                            }
                            mainCornerCeilingPiece.render(graphicsHolder, x, this.heightOffset, z, 0.0f, light, OverlayTexture.getDefaultUvMapped());
                        }
                        if (!(edge1X || !edge2X || edge1Z || !edge2Z || this.width <= 2 && this.isDoubleSided)) {
                            mainCornerPiece.render(graphicsHolder, x, z, 1.5707964f, light, OverlayTexture.getDefaultUvMapped());
                            if (renderStage == RenderStage.INTERIOR) {
                                this.renderWall(mainCornerWallPiece, graphicsHolder, x, z, 1.5707964f, light);
                            }
                            mainCornerCeilingPiece.render(graphicsHolder, x, this.heightOffset, z, 1.5707964f, light, OverlayTexture.getDefaultUvMapped());
                        }
                        if (edge1X && !edge2X && edge1Z && !edge2Z && this.width > 2) {
                            mainCornerPiece.render(graphicsHolder, x, z, -1.5707964f, light, OverlayTexture.getDefaultUvMapped());
                            if (renderStage == RenderStage.INTERIOR) {
                                this.renderWall(mainCornerWallPiece, graphicsHolder, x, z, -1.5707964f, light);
                            }
                            mainCornerCeilingPiece.render(graphicsHolder, x, this.heightOffset, z, -1.5707964f, light, OverlayTexture.getDefaultUvMapped());
                        }
                        if (edge1X || !edge2X || !edge1Z || edge2Z || this.width <= 2) continue block5;
                        mainCornerPiece.render(graphicsHolder, x, z, (float)Math.PI, light, OverlayTexture.getDefaultUvMapped());
                        if (renderStage == RenderStage.INTERIOR) {
                            this.renderWall(mainCornerWallPiece, graphicsHolder, x, z, (float)Math.PI, light);
                        }
                        mainCornerCeilingPiece.render(graphicsHolder, x, this.heightOffset, z, (float)Math.PI, light, OverlayTexture.getDefaultUvMapped());
                    }
                }
            }
        }
        if (renderStage == RenderStage.INTERIOR || renderStage == RenderStage.EXTERIOR) {
            ModelPartExtension doorLeftPiece = renderStage == RenderStage.INTERIOR ? this.door_left : this.door_left_exterior;
            ModelPartExtension doorRightPiece = renderStage == RenderStage.INTERIOR ? this.door_right : this.door_right_exterior;
            ModelPartExtension doorPiece = renderStage == RenderStage.INTERIOR ? this.door : this.door_exterior;
            ModelPartExtension doorWallPiece = renderStage == RenderStage.INTERIOR ? this.door_wall : this.door_wall_exterior;
            ModelPartExtension doorCeilingPiece = renderStage == RenderStage.INTERIOR ? this.door_ceiling : this.door_ceiling_exterior;
            ModelPartExtension mainEdgePiece = renderStage == RenderStage.INTERIOR ? this.main_edge : this.main_exterior_edge;
            ModelPartExtension mainEdgeCeilingPiece = renderStage == RenderStage.INTERIOR ? this.main_edge_ceiling : this.main_exterior_edge_ceiling;
            ModelTrainBase.renderOnceFlipped(doorLeftPiece, graphicsHolder, light, -doorLeftZ, 8 - this.depth * 8);
            ModelTrainBase.renderOnceFlipped(doorRightPiece, graphicsHolder, light, doorLeftZ, 8 - this.depth * 8);
            ModelTrainBase.renderOnceFlipped(doorPiece, graphicsHolder, light, 8 - this.depth * 8);
            this.renderWallOnceFlipped(doorWallPiece, graphicsHolder, 0.0f, 8 - this.depth * 8, light);
            ModelTrainBase.renderOnceFlipped(doorCeilingPiece, graphicsHolder, light, 0.0f, this.heightOffset, 8 - this.depth * 8);
            if (this.isDoubleSided) {
                ModelTrainBase.renderOnce(doorLeftPiece, graphicsHolder, light, -doorRightZ, -8 + this.depth * 8);
                ModelTrainBase.renderOnce(doorRightPiece, graphicsHolder, light, doorRightZ, -8 + this.depth * 8);
                ModelTrainBase.renderOnce(doorPiece, graphicsHolder, light, -8 + this.depth * 8);
                this.renderWallOnce(doorWallPiece, graphicsHolder, 0.0f, -8 + this.depth * 8, light);
                ModelTrainBase.renderOnce(doorCeilingPiece, graphicsHolder, light, 0.0f, this.heightOffset, -8 + this.depth * 8);
            }
            if (renderStage == RenderStage.INTERIOR && this.width == 2) {
                ModelTrainBase.renderOnceFlipped(this.wall_patch, graphicsHolder, light, 8 - this.depth * 8);
                this.renderWallOnceFlipped(this.wall_patch_wall, graphicsHolder, 0.0f, 8 - this.depth * 8, light);
                if (this.isDoubleSided) {
                    ModelTrainBase.renderOnce(this.wall_patch, graphicsHolder, light, -8 + this.depth * 8);
                    this.renderWallOnce(this.wall_patch_wall, graphicsHolder, 0.0f, -8 + this.depth * 8, light);
                }
            }
            for (int i = 1; i < this.width - 2; ++i) {
                ModelTrainBase.renderOnceFlipped(mainEdgePiece, graphicsHolder, light, i * 8 - this.width * 8 + 4, -this.depth * 8);
                ModelTrainBase.renderOnceFlipped(mainEdgePiece, graphicsHolder, light, -i * 8 + this.width * 8 - 4, -this.depth * 8);
                if (renderStage == RenderStage.INTERIOR) {
                    this.renderWallOnceFlipped(this.main_edge_wall, graphicsHolder, i * 8 - this.width * 8 + 4, -this.depth * 8, light);
                    this.renderWallOnceFlipped(this.main_edge_wall, graphicsHolder, -i * 8 + this.width * 8 - 4, -this.depth * 8, light);
                }
                ModelTrainBase.renderOnceFlipped(mainEdgeCeilingPiece, graphicsHolder, light, i * 8 - this.width * 8 + 4, this.heightOffset, -this.depth * 8);
                ModelTrainBase.renderOnceFlipped(mainEdgeCeilingPiece, graphicsHolder, light, -i * 8 + this.width * 8 - 4, this.heightOffset, -this.depth * 8);
                if (!this.isDoubleSided) continue;
                ModelTrainBase.renderOnce(mainEdgePiece, graphicsHolder, light, i * 8 - this.width * 8 + 4, this.depth * 8);
                ModelTrainBase.renderOnce(mainEdgePiece, graphicsHolder, light, -i * 8 + this.width * 8 - 4, this.depth * 8);
                if (renderStage == RenderStage.INTERIOR) {
                    this.renderWallOnce(this.main_edge_wall, graphicsHolder, i * 8 - this.width * 8 + 4, this.depth * 8, light);
                    this.renderWallOnce(this.main_edge_wall, graphicsHolder, -i * 8 + this.width * 8 - 4, this.depth * 8, light);
                }
                ModelTrainBase.renderOnce(mainEdgeCeilingPiece, graphicsHolder, light, i * 8 - this.width * 8 + 4, this.heightOffset, this.depth * 8);
                ModelTrainBase.renderOnce(mainEdgeCeilingPiece, graphicsHolder, light, -i * 8 + this.width * 8 - 4, this.heightOffset, this.depth * 8);
            }
        }
    }

    @Override
    protected void baseTransform(GraphicsHolder graphicsHolder) {
        graphicsHolder.translate(0.0, "4.0.2+1.20.1".endsWith("1.16.5") ? 0.0 : -1.5, 0.0);
    }

    @Override
    protected int getDoorMax() {
        return 6;
    }

    private void renderWall(ModelPartExtension model, GraphicsHolder graphicsHolder, float x, float z, float rotateY, int light) {
        for (int i = 0; i < this.heightCount; ++i) {
            model.render(graphicsHolder, x, -i * 8, z, rotateY, light, OverlayTexture.getDefaultUvMapped());
        }
    }

    private void renderWallOnce(ModelPartExtension model, GraphicsHolder graphicsHolder, float x, float z, int light) {
        for (int i = 0; i < this.heightCount; ++i) {
            ModelTrainBase.renderOnce(model, graphicsHolder, light, x, -i * 8, z);
        }
    }

    private void renderWallOnceFlipped(ModelPartExtension model, GraphicsHolder graphicsHolder, float x, float z, int light) {
        for (int i = 0; i < this.heightCount; ++i) {
            ModelTrainBase.renderOnceFlipped(model, graphicsHolder, light, x, -i * 8, z);
        }
    }
}

