/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mod.packet;

import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.mtr.mapping.holder.Inventory;
import org.mtr.mapping.holder.Items;
import org.mtr.mapping.holder.MinecraftServer;
import org.mtr.mapping.holder.PlayerEntity;
import org.mtr.mapping.holder.ServerPlayerEntity;
import org.mtr.mapping.holder.ServerWorld;
import org.mtr.mapping.holder.SoundCategory;
import org.mtr.mapping.holder.SoundEvents;
import org.mtr.mapping.holder.World;
import org.mtr.mapping.mapper.InventoryHelper;
import org.mtr.mapping.mapper.PlayerHelper;
import org.mtr.mapping.registry.PacketHandler;
import org.mtr.mapping.tool.PacketBufferReceiver;
import org.mtr.mapping.tool.PacketBufferSender;
import org.mtr.mod.data.TicketSystem;

public final class PacketAddBalance
extends PacketHandler {
    private final int index;
    private static final int EMERALD_TO_DOLLAR = 10;

    public PacketAddBalance(PacketBufferReceiver packetBufferReceiver) {
        this.index = packetBufferReceiver.readInt();
    }

    public PacketAddBalance(int index) {
        this.index = index;
    }

    @Override
    public void write(PacketBufferSender packetBufferSender) {
        packetBufferSender.writeInt(this.index);
    }

    @Override
    public void runServer(MinecraftServer minecraftServer, ServerPlayerEntity serverPlayerEntity) {
        ServerWorld serverWorld = serverPlayerEntity.getServerWorld();
        TicketSystem.addBalance(new World((Level)serverWorld.data), new PlayerEntity((Player)serverPlayerEntity.data), PacketAddBalance.getAddAmount(this.index));
        InventoryHelper.remove(new Inventory((Container)PlayerHelper.getPlayerInventory((PlayerEntity)new PlayerEntity((Player)((Player)serverPlayerEntity.data))).data), itemStack -> itemStack.getItem().equals(Items.getEmeraldMapped()), (int)Math.pow(2.0, this.index), false);
        serverWorld.playSound(null, serverPlayerEntity.getBlockPos(), SoundEvents.getEntityExperienceOrbPickupMapped(), SoundCategory.getBlocksMapped(), 1.0f, 1.0f);
    }

    public static int getAddAmount(int index) {
        return (int)Math.ceil(Math.pow(2.0, index) * (double)(10 + index));
    }
}

