/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mod.packet;

import java.util.Random;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import org.mtr.libraries.it.unimi.dsi.fastutil.longs.Long2ObjectAVLTreeMap;
import org.mtr.mapping.holder.MinecraftServer;
import org.mtr.mapping.holder.ServerPlayerEntity;
import org.mtr.mapping.registry.PacketHandler;
import org.mtr.mapping.tool.PacketBufferReceiver;
import org.mtr.mapping.tool.PacketBufferSender;
import org.mtr.mod.Init;

public final class PacketForwardClientRequest
extends PacketHandler {
    private final String endpoint;
    private final String content;
    private final String path;
    private final long callbackId;
    private static final Long2ObjectAVLTreeMap<BiConsumer<String, String>> CALLBACKS = new Long2ObjectAVLTreeMap();

    public PacketForwardClientRequest(PacketBufferReceiver packetBufferReceiver) {
        this.endpoint = packetBufferReceiver.readString();
        this.content = packetBufferReceiver.readString();
        this.path = packetBufferReceiver.readString();
        this.callbackId = packetBufferReceiver.readLong();
    }

    public PacketForwardClientRequest(String endpoint, @Nullable String content, BiConsumer<String, String> callback) {
        this.endpoint = endpoint;
        this.content = content == null ? "" : content;
        this.path = "";
        this.callbackId = new Random().nextLong();
        CALLBACKS.put(this.callbackId, callback);
    }

    private PacketForwardClientRequest(@Nullable String content, String path, long callbackId) {
        this.endpoint = "";
        this.content = content == null ? "" : content;
        this.path = path;
        this.callbackId = callbackId;
    }

    @Override
    public void write(PacketBufferSender packetBufferSender) {
        packetBufferSender.writeString(this.endpoint);
        packetBufferSender.writeString(this.content);
        packetBufferSender.writeString(this.path);
        packetBufferSender.writeLong(this.callbackId);
    }

    @Override
    public void runServer(MinecraftServer minecraftServer, ServerPlayerEntity serverPlayerEntity) {
        Init.REQUEST_HELPER.sendRequest(String.format("http://localhost:%s%s", Init.getServerPort(), this.endpoint), this.content.isEmpty() ? null : this.content, (response, path) -> Init.REGISTRY.sendPacketToClient(serverPlayerEntity, new PacketForwardClientRequest((String)response, (String)path, this.callbackId)));
    }

    @Override
    public void runClient() {
        BiConsumer<String, String> callback = CALLBACKS.remove(this.callbackId);
        if (callback != null) {
            callback.accept(this.content, this.path);
        }
    }
}

