/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mod.render;

import org.mtr.core.data.Platform;
import org.mtr.core.data.Station;
import org.mtr.mapping.holder.BlockEntityAbstractMapping;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.BlockState;
import org.mtr.mapping.holder.Direction;
import org.mtr.mapping.holder.World;
import org.mtr.mapping.mapper.BlockEntityRenderer;
import org.mtr.mapping.mapper.GraphicsHolder;
import org.mtr.mod.InitClient;
import org.mtr.mod.block.BlockRouteSignBase;
import org.mtr.mod.block.BlockStationNameBase;
import org.mtr.mod.block.IBlock;
import org.mtr.mod.client.DynamicTextureCache;
import org.mtr.mod.client.IDrawing;
import org.mtr.mod.data.IGui;
import org.mtr.mod.render.MoreRenderLayers;

public class RenderRouteSign<T extends BlockRouteSignBase.BlockEntityBase>
extends BlockEntityRenderer<T>
implements IBlock,
IGui {
    private static final float SIDE = 0.15625f;
    private static final float BOTTOM = 0.65625f;
    private static final float MIDDLE = 0.8125f;
    private static final float TOP = 0.96875f;
    private static final float WIDTH = 0.6875f;
    private static final float HEIGHT_BOTTOM = 1.15625f;
    private static final float HEIGHT_TOP = 0.15625f;
    private static final float TEXTURE_BREAK = 0.7027027f;

    public RenderRouteSign(BlockEntityRenderer.Argument dispatcher) {
        super(dispatcher);
    }

    @Override
    public void render(T entity, float tickDelta, GraphicsHolder graphicsHolder, int light, int overlay) {
        World world = ((BlockEntityAbstractMapping)((Object)entity)).getWorld2();
        if (world == null) {
            return;
        }
        BlockPos pos = ((BlockEntityAbstractMapping)((Object)entity)).getPos2();
        BlockState state = world.getBlockState(pos);
        Direction facing = IBlock.getStatePropertySafe(state, BlockStationNameBase.FACING);
        boolean isTop = IBlock.getStatePropertySafe(state, HALF) == IBlock.DoubleBlockHalf.UPPER;
        int arrowDirection = IBlock.getStatePropertySafe(state, BlockRouteSignBase.ARROW_DIRECTION);
        Station station = InitClient.findStation(pos);
        if (station == null) {
            return;
        }
        if (station.savedRails.isEmpty()) {
            return;
        }
        Platform platform = station.savedRails.stream().filter(checkPlatform -> checkPlatform.getId() == entity.getPlatformId()).findFirst().orElse(null);
        if (platform == null) {
            return;
        }
        graphicsHolder.push();
        graphicsHolder.translate(0.5, 0.0, 0.5);
        graphicsHolder.rotateYDegrees(-facing.asRotation());
        graphicsHolder.translate(-0.5, 0.0, 0.43124999990686774);
        graphicsHolder.createVertexConsumer(MoreRenderLayers.getExterior(DynamicTextureCache.instance.getDirectionArrow((long)platform.getId(), (boolean)((arrowDirection & 1) > 0 ? true : false), (boolean)((arrowDirection & 2) > 0 ? true : false), (IGui.HorizontalAlignment)IGui.HorizontalAlignment.CENTER, (boolean)true, (float)0.2f, (float)4.4f, (int)-16777216, (int)-1, (int)0).identifier));
        IDrawing.drawTexture(graphicsHolder, 0.84375f, 0.96875f + (float)(!isTop ? 1 : 0), 0.0f, 0.15625f, 0.8125f + (float)(!isTop ? 1 : 0), 0.0f, 0.0f, 0.0f, 1.0f, 1.0f, facing.getOpposite(), -1, light);
        graphicsHolder.createVertexConsumer(MoreRenderLayers.getExterior(DynamicTextureCache.instance.getRouteMap((long)platform.getId(), (boolean)true, (boolean)false, (float)1.6818181f, (boolean)false).identifier));
        IDrawing.drawTexture(graphicsHolder, 0.84375f, 0.8125f + (float)(!isTop ? 1 : 0), 0.0f, 0.84375f, isTop ? 0.0f : 0.65625f, 0.0f, 0.15625f, isTop ? 0.0f : 0.65625f, 0.0f, 0.15625f, 0.8125f + (float)(!isTop ? 1 : 0), 0.0f, 0.0f, 0.0f, isTop ? 0.7027027f : 1.0f, 1.0f, facing.getOpposite(), -1, light);
        graphicsHolder.pop();
    }

    @Override
    public boolean rendersOutsideBoundingBox2(T blockEntity) {
        return true;
    }
}

