/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mapping.holder;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.class_1159;
import net.minecraft.class_2350;
import org.mtr.mapping.annotation.MappedMethod;
import org.mtr.mapping.holder.Axis;
import org.mtr.mapping.holder.Matrix4f;
import org.mtr.mapping.holder.Random;
import org.mtr.mapping.holder.Vector3f;
import org.mtr.mapping.holder.Vector3i;

@ParametersAreNonnullByDefault
public enum Direction {
    DOWN(class_2350.field_11033),
    UP(class_2350.field_11036),
    NORTH(class_2350.field_11043),
    SOUTH(class_2350.field_11035),
    WEST(class_2350.field_11039),
    EAST(class_2350.field_11034);

    public final class_2350 data;

    private Direction(class_2350 data) {
        this.data = data;
    }

    public static Direction convert(@Nullable class_2350 data) {
        return data == null ? null : Direction.values()[data.ordinal()];
    }

    @MappedMethod
    public final boolean equals(@Nullable Direction data) {
        return data != null && this.data == data.data;
    }

    @Nonnull
    @MappedMethod
    public static Direction random(Random random) {
        return Direction.convert(class_2350.method_10162((java.util.Random)((java.util.Random)random.data)));
    }

    @Nonnull
    @MappedMethod
    public static Direction transform(Matrix4f matrix, Direction direction) {
        return Direction.convert(class_2350.method_23225((class_1159)((class_1159)matrix.data), (class_2350)direction.data));
    }

    @MappedMethod
    public float asRotation() {
        return this.data.method_10144();
    }

    @Nonnull
    @MappedMethod
    public static Direction fromRotation(double rotation) {
        return Direction.convert(class_2350.method_10150((double)rotation));
    }

    @MappedMethod
    public int getId() {
        return this.data.method_10146();
    }

    @Nonnull
    @MappedMethod
    public static Direction fromHorizontal(int value) {
        return Direction.convert(class_2350.method_10139((int)value));
    }

    @MappedMethod
    public int getOffsetY() {
        return this.data.method_10164();
    }

    @MappedMethod
    public int getOffsetZ() {
        return this.data.method_10165();
    }

    @Nonnull
    @MappedMethod
    public Direction rotateYCounterclockwise() {
        return Direction.convert(this.data.method_10160());
    }

    @MappedMethod
    public boolean method_30928(float yaw) {
        return this.data.method_30928(yaw);
    }

    @Nonnull
    @MappedMethod
    public static Direction getFacing(float x, float y, float z) {
        return Direction.convert(class_2350.method_10147((float)x, (float)y, (float)z));
    }

    @Nonnull
    @MappedMethod
    public static Direction getFacing(double x, double y, double z) {
        return Direction.convert(class_2350.method_10142((double)x, (double)y, (double)z));
    }

    @Nonnull
    @MappedMethod
    public Direction getOpposite() {
        return Direction.convert(this.data.method_10153());
    }

    @Nonnull
    @MappedMethod
    public static Direction byId(int id) {
        return Direction.convert(class_2350.method_10143((int)id));
    }

    @Nullable
    @MappedMethod
    public static Direction fromVector(int x, int y, int z) {
        class_2350 tempData = class_2350.method_16365((int)x, (int)y, (int)z);
        return tempData == null ? null : Direction.convert(tempData);
    }

    @Nonnull
    @MappedMethod
    public Axis getAxis() {
        return Axis.convert(this.data.method_10166());
    }

    @MappedMethod
    public int getHorizontal() {
        return this.data.method_10161();
    }

    @MappedMethod
    public int getOffsetX() {
        return this.data.method_10148();
    }

    @Nonnull
    @MappedMethod
    public String asString() {
        return this.data.method_15434();
    }

    @Nonnull
    @MappedMethod
    public String getName() {
        return this.data.method_10151();
    }

    @Nonnull
    @MappedMethod
    public Vector3i getVector() {
        return new Vector3i(this.data.method_10163());
    }

    @Nullable
    @MappedMethod
    public static Direction byName(@Nullable String name) {
        class_2350 tempData = class_2350.method_10168((String)name);
        return tempData == null ? null : Direction.convert(tempData);
    }

    @Nonnull
    @MappedMethod
    public Direction rotateYClockwise() {
        return Direction.convert(this.data.method_10170());
    }

    @Nonnull
    @MappedMethod
    public Vector3f getUnitVector() {
        return new Vector3f(this.data.method_23955());
    }

    @Nonnull
    @MappedMethod
    public static Direction getNorthMapped() {
        return Direction.convert(class_2350.field_11043);
    }

    @Nonnull
    @MappedMethod
    public static Direction getUpMapped() {
        return Direction.convert(class_2350.field_11036);
    }

    @Nonnull
    @MappedMethod
    public static Direction getSouthMapped() {
        return Direction.convert(class_2350.field_11035);
    }

    @Nonnull
    @MappedMethod
    public static Direction getEastMapped() {
        return Direction.convert(class_2350.field_11034);
    }

    @Nonnull
    @MappedMethod
    public static Direction getDownMapped() {
        return Direction.convert(class_2350.field_11033);
    }

    @Nonnull
    @MappedMethod
    public static Direction getWestMapped() {
        return Direction.convert(class_2350.field_11039);
    }
}

