/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mod.packet;

import java.util.Random;
import java.util.function.Consumer;
import org.mtr.libraries.it.unimi.dsi.fastutil.longs.Long2ObjectAVLTreeMap;
import org.mtr.mapping.holder.MinecraftServer;
import org.mtr.mapping.holder.ServerPlayerEntity;
import org.mtr.mapping.mapper.PersistenceStateExtension;
import org.mtr.mapping.registry.PacketHandler;
import org.mtr.mapping.tool.PacketBufferReceiver;
import org.mtr.mapping.tool.PacketBufferSender;
import org.mtr.mod.Init;
import org.mtr.mod.client.MinecraftClientData;
import org.mtr.mod.data.PersistentStateData;

public final class PacketCheckRouteIdHasDisabledAnnouncements
extends PacketHandler {
    private final long routeId;
    private final boolean isDisabled;
    private final long callbackId;
    private static final Long2ObjectAVLTreeMap<Consumer<Boolean>> CALLBACKS = new Long2ObjectAVLTreeMap();

    public PacketCheckRouteIdHasDisabledAnnouncements(PacketBufferReceiver packetBufferReceiver) {
        this.routeId = packetBufferReceiver.readLong();
        this.isDisabled = packetBufferReceiver.readBoolean();
        this.callbackId = packetBufferReceiver.readLong();
    }

    public PacketCheckRouteIdHasDisabledAnnouncements(long routeId, Consumer<Boolean> callback) {
        this.routeId = routeId;
        this.isDisabled = false;
        this.callbackId = new Random().nextLong();
        CALLBACKS.put(this.callbackId, callback);
    }

    private PacketCheckRouteIdHasDisabledAnnouncements(long routeId, boolean isDisabled, long callbackId) {
        this.routeId = routeId;
        this.isDisabled = isDisabled;
        this.callbackId = callbackId;
    }

    @Override
    public void write(PacketBufferSender packetBufferSender) {
        packetBufferSender.writeLong(this.routeId);
        packetBufferSender.writeBoolean(this.isDisabled);
        packetBufferSender.writeLong(this.callbackId);
    }

    @Override
    public void runServer(MinecraftServer minecraftServer, ServerPlayerEntity serverPlayerEntity) {
        PersistentStateData persistentStateData = (PersistentStateData)PersistenceStateExtension.register(serverPlayerEntity.getServerWorld(), PersistentStateData::new, "mtr");
        Init.REGISTRY.sendPacketToClient(serverPlayerEntity, new PacketCheckRouteIdHasDisabledAnnouncements(this.routeId, persistentStateData.getRouteIdHasDisabledAnnouncements(this.routeId), this.callbackId));
    }

    @Override
    public void runClient() {
        MinecraftClientData.getInstance().setRouteIdHasDisabledAnnouncements(this.routeId, this.isDisabled);
        Consumer<Boolean> callback = CALLBACKS.remove(this.callbackId);
        if (callback != null) {
            callback.accept(this.isDisabled);
        }
    }
}

