/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mod.screen;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_339;
import org.mtr.core.data.Siding;
import org.mtr.core.data.TransportMode;
import org.mtr.core.data.VehicleCar;
import org.mtr.core.operation.UpdateDataRequest;
import org.mtr.libraries.com.google.gson.JsonObject;
import org.mtr.libraries.it.unimi.dsi.fastutil.longs.LongArrayList;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.Object2ObjectAVLTreeMap;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectArrayList;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectImmutableList;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectList;
import org.mtr.mapping.holder.ClickableWidget;
import org.mtr.mapping.holder.MutableText;
import org.mtr.mapping.holder.OrderedText;
import org.mtr.mapping.mapper.ButtonWidgetExtension;
import org.mtr.mapping.mapper.GraphicsHolder;
import org.mtr.mapping.mapper.ScreenExtension;
import org.mtr.mapping.mapper.TextHelper;
import org.mtr.mod.Icons;
import org.mtr.mod.Init;
import org.mtr.mod.InitClient;
import org.mtr.mod.client.CustomResourceLoader;
import org.mtr.mod.client.IDrawing;
import org.mtr.mod.client.MinecraftClientData;
import org.mtr.mod.generated.lang.TranslationProvider;
import org.mtr.mod.packet.PacketUpdateData;
import org.mtr.mod.resource.VehicleResource;
import org.mtr.mod.screen.DashboardListItem;
import org.mtr.mod.screen.DashboardListSelectorScreen;

public class VehicleSelectorScreen
extends DashboardListSelectorScreen
implements Icons {
    private final ButtonWidgetExtension buttonDuplicateVehicleCars = new ButtonWidgetExtension(0, 0, 0, 20, TranslationProvider.GUI_MTR_DUPLICATE_VEHICLE_CARS.getMutableText(new Object[0]), button -> {
        int currentCarCount;
        ObjectArrayList<VehicleCar> existingCars = new ObjectArrayList<VehicleCar>((ObjectList<VehicleCar>)siding.getVehicleCars());
        do {
            ObjectArrayList<VehicleCar> currentCars = new ObjectArrayList<VehicleCar>((ObjectList<VehicleCar>)siding.getVehicleCars());
            currentCarCount = currentCars.size();
            currentCars.addAll((ObjectList<VehicleCar>)existingCars);
            siding.setVehicleCars(currentCars);
        } while (siding.getVehicleCars().size() != currentCarCount);
        this.selectedIds.clear();
        this.selectedIds.addAll(VehicleSelectorScreen.getSelectedIds(siding));
        this.updateList();
    });
    private final Siding siding;
    private static final Object2ObjectAVLTreeMap<String, String> WIKIPEDIA_ARTICLES = new Object2ObjectAVLTreeMap();

    public VehicleSelectorScreen(Siding siding, ScreenExtension previousScreenExtension) {
        super(VehicleSelectorScreen.getVehicleList(siding.getTransportMode()), VehicleSelectorScreen.getSelectedIds(siding), false, true, previousScreenExtension);
        this.siding = siding;
    }

    @Override
    protected void init2() {
        super.init2();
        int spareSpace = Math.max(0, this.field_22789 - 80 - 288);
        this.availableList.x = 40 + spareSpace;
        this.selectedList.x = 60 + spareSpace + 144;
        IDrawing.setPositionAndWidth(this.buttonDone, 40 + spareSpace, this.field_22790 - 40, 144);
        IDrawing.setPositionAndWidth(this.buttonDuplicateVehicleCars, 60 + spareSpace + 144, this.field_22790 - 40, 144);
        this.addChild(new ClickableWidget((class_339)this.buttonDuplicateVehicleCars));
    }

    @Override
    public void renderAdditional(GraphicsHolder graphicsHolder, int mouseX, int mouseY, float delta) {
        int spareSpace = Math.max(0, this.field_22789 - 80 - 288);
        graphicsHolder.drawCenteredText(TranslationProvider.GUI_MTR_AVAILABLE.getMutableText(new Object[0]), 40 + spareSpace + 72, 20, -1);
        graphicsHolder.drawCenteredText(TranslationProvider.GUI_MTR_SELECTED.getMutableText(new Object[0]), 60 + spareSpace + 216, 20, -1);
        int index = this.availableList.getHoverItemIndex();
        CustomResourceLoader.getVehicleByIndex(this.siding.getTransportMode(), index, vehicleResource -> {
            String wikipediaArticle;
            int y = 20;
            y = this.drawWrappedText(graphicsHolder, vehicleResource.getName(), y, -1);
            y = this.drawWrappedText(graphicsHolder, TranslationProvider.GUI_MTR_VEHICLE_LENGTH.getMutableText(vehicleResource.getLength()), y, -1);
            String description = vehicleResource.getDescription().getString();
            if (!description.isEmpty()) {
                for (String text : description.split("[|\n]")) {
                    y = this.drawWrappedText(graphicsHolder, TextHelper.literal(text), y, -5592406);
                }
            }
            if (!(wikipediaArticle = vehicleResource.getWikipediaArticle()).isEmpty()) {
                String fullText = VehicleSelectorScreen.fetchWikipediaArticle(wikipediaArticle);
                for (String text : fullText.split("\n")) {
                    y = this.drawWrappedText(graphicsHolder, TextHelper.literal(text), y, -5592406);
                }
            }
        });
    }

    @Override
    protected void updateList() {
        ObjectArrayList<VehicleCar> tempList = new ObjectArrayList<VehicleCar>();
        this.selectedIds.forEach(selectedId -> this.allData.stream().filter(data -> data.id == selectedId).findFirst().ifPresent(data -> {
            if (data instanceof VehicleForList) {
                VehicleResource vehicleResource = ((VehicleForList)data).vehicleResource;
                tempList.add(new VehicleCar(vehicleResource.getId(), vehicleResource.getLength(), vehicleResource.getWidth(), vehicleResource.getBogie1Position(), vehicleResource.getBogie2Position(), vehicleResource.getCouplingPadding1(), vehicleResource.getCouplingPadding2()));
            }
        }));
        this.siding.setVehicleCars(tempList);
        this.selectedIds.clear();
        this.selectedIds.addAll(VehicleSelectorScreen.getSelectedIds(this.siding));
        super.updateList();
        InitClient.REGISTRY_CLIENT.sendPacketToServer(new PacketUpdateData(new UpdateDataRequest(MinecraftClientData.getDashboardInstance()).addSiding(this.siding)));
        ObjectArrayList<VehicleCar> currentList = this.siding.getVehicleCars();
        double remainingLength = this.siding.getRailLength();
        for (int i = 0; i < currentList.size(); ++i) {
            remainingLength -= currentList.get(i).getTotalLength(i == 0, false);
        }
        for (DashboardListItem data : this.allData) {
            if (!(data instanceof VehicleForList)) continue;
            VehicleForList vehicleForList = (VehicleForList)data;
            vehicleForList.disabled = vehicleForList.vehicleResource.getCouplingPadding1() + vehicleForList.vehicleResource.getLength() > remainingLength;
        }
    }

    private int drawWrappedText(GraphicsHolder graphicsHolder, MutableText component, int y, int color) {
        List<OrderedText> splitText = GraphicsHolder.wrapLines(component, Math.max(0, this.field_22789 - 80 - 288));
        int newY = y;
        for (OrderedText formattedCharSequence : splitText) {
            int nextY = newY + 8 + 2;
            if (nextY > this.field_22790 - 20 - 8) {
                graphicsHolder.drawText("...", 20, newY, color, false, GraphicsHolder.getDefaultLight());
                return this.field_22790;
            }
            graphicsHolder.drawText(formattedCharSequence, 20, newY, color, false, GraphicsHolder.getDefaultLight());
            newY = nextY;
        }
        return newY + 6;
    }

    private static ObjectImmutableList<DashboardListItem> getVehicleList(TransportMode transportMode) {
        ObjectArrayList trainsForList = new ObjectArrayList();
        long[] id = new long[]{0L};
        CustomResourceLoader.iterateVehicles(transportMode, vehicleResource -> {
            trainsForList.add(new VehicleForList(id[0], (VehicleResource)vehicleResource));
            id[0] = id[0] + 1L;
        });
        return new ObjectImmutableList<DashboardListItem>(trainsForList);
    }

    private static LongArrayList getSelectedIds(Siding siding) {
        ObjectImmutableList<DashboardListItem> trainsForList = VehicleSelectorScreen.getVehicleList(siding.getTransportMode());
        LongArrayList selectedIds = new LongArrayList();
        siding.getVehicleCars().forEach(vehicleCar -> trainsForList.stream().filter(data -> data instanceof VehicleForList && vehicleCar.getVehicleId().equals(((VehicleForList)data).vehicleResource.getId())).mapToLong(data -> data.id).findFirst().ifPresent(selectedIds::add));
        return selectedIds;
    }

    private static String fetchWikipediaArticle(String wikipediaArticle) {
        String result = WIKIPEDIA_ARTICLES.get(wikipediaArticle);
        if (result == null) {
            CompletableFuture.runAsync(() -> Init.openConnectionSafeJson("https://en.wikipedia.org/w/api.php?format=json&action=query&prop=extracts&explaintext&exintro&titles=" + wikipediaArticle, jsonElement -> {
                JsonObject pagesObject = jsonElement.getAsJsonObject().getAsJsonObject("query").getAsJsonObject("pages");
                pagesObject.entrySet().stream().findFirst().ifPresent(entry -> WIKIPEDIA_ARTICLES.put(wikipediaArticle, pagesObject.getAsJsonObject((String)entry.getKey()).get("extract").getAsString()));
            }, new String[0]));
            WIKIPEDIA_ARTICLES.put(wikipediaArticle, "");
            return "";
        }
        return result;
    }

    private static class VehicleForList
    extends DashboardListItem {
        private boolean disabled;
        private final VehicleResource vehicleResource;

        public VehicleForList(long index, VehicleResource vehicleResource) {
            super(index, vehicleResource.getName().getString(), vehicleResource.getColor());
            this.vehicleResource = vehicleResource;
        }

        @Override
        public String getName(boolean formatted) {
            return String.format("%s%s", this.disabled && formatted ? "\u26a0 " : "", super.getName(formatted));
        }

        @Override
        public int getColor(boolean formatted) {
            return this.disabled && formatted ? -16777216 : super.getColor(formatted);
        }
    }
}

