/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.creativeblockreplacer_common_neoforge.events;

import com.natamus.collective_common_neoforge.functions.MessageFunctions;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;

public class ReplaceEvent {
    private static final Map<String, Boolean> replacingplayers = new HashMap<String, Boolean>();
    private static final Map<String, Integer> sneaktotal = new HashMap<String, Integer>();
    private static final Map<String, Integer> sneakcurrent = new HashMap<String, Integer>();
    private static final Map<String, BlockPos> lastpos = new HashMap<String, BlockPos>();

    public static void onPlayerTick(ServerLevel level, ServerPlayer player) {
        if (!player.isCreative()) {
            return;
        }
        String playername = player.getName().getString();
        BlockPos playerpos = player.blockPosition();
        if (lastpos.containsKey(playername) && sneaktotal.containsKey(playername) && !lastpos.get(playername).equals((Object)playerpos)) {
            sneaktotal.remove(playername);
            sneakcurrent.remove(playername);
        }
        lastpos.put(playername, playerpos);
        if (player.isShiftKeyDown()) {
            if (sneakcurrent.containsKey(playername)) {
                return;
            }
            int totalsneak = 0;
            if (sneaktotal.containsKey(playername)) {
                totalsneak = sneaktotal.get(playername);
            }
            sneaktotal.put(playername, totalsneak + 1);
            sneakcurrent.put(playername, totalsneak + 1);
            return;
        }
        if (!sneakcurrent.containsKey(playername)) {
            return;
        }
        int current = sneakcurrent.get(playername);
        if (current > 2) {
            boolean isreplacing;
            sneaktotal.put(playername, 0);
            sneakcurrent.remove(playername);
            if (replacingplayers.containsKey(playername) && (isreplacing = replacingplayers.get(playername).booleanValue())) {
                replacingplayers.put(playername, false);
                MessageFunctions.sendMessage((Player)player, (String)"Replacing block mode disabled.", (ChatFormatting)ChatFormatting.YELLOW);
                return;
            }
            replacingplayers.put(playername, true);
            MessageFunctions.sendMessage((Player)player, (String)"Replacing block mode enabled", (ChatFormatting)ChatFormatting.YELLOW);
            return;
        }
        sneakcurrent.remove(playername);
    }

    public static boolean onBlockClick(Level level, Player player, InteractionHand hand, BlockPos pos, BlockHitResult hitVec) {
        if (!hand.equals((Object)InteractionHand.MAIN_HAND)) {
            return true;
        }
        if (!player.isCreative()) {
            return true;
        }
        String playername = player.getName().getString();
        if (!replacingplayers.containsKey(playername)) {
            return true;
        }
        boolean isreplacing = replacingplayers.get(playername);
        if (!isreplacing) {
            return true;
        }
        ItemStack itemStack = player.getItemInHand(hand);
        Block toblock = Block.byItem((Item)itemStack.getItem());
        BlockState tostate = toblock.defaultBlockState();
        level.setBlockAndUpdate(pos, tostate);
        return false;
    }
}

