/*
 * Decompiled with CFR 0.152.
 */
package jagm.jagmkiwis;

import jagm.jagmkiwis.KiwiEntity;
import jagm.jagmkiwis.KiwiMod;
import jagm.jagmkiwis.KiwiModEntities;
import jagm.jagmkiwis.KiwiModItems;
import jagm.jagmkiwis.KiwiModSounds;
import jagm.jagmkiwis.KiwiModel;
import jagm.jagmkiwis.KiwiRenderer;
import jagm.jagmkiwis.LaserBeamRenderer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.SpawnPlacementTypes;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Cat;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.SpawnPlacementRegisterEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

@Mod(value="jagmkiwis")
public class ForgeEntrypoint {
    static final DeferredRegister<Item> ITEMS_FORGE = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"jagmkiwis");
    static final DeferredRegister<EntityType<?>> ENTITIES_FORGE = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITY_TYPES, (String)"jagmkiwis");
    static final DeferredRegister<SoundEvent> SOUNDS_FORGE = DeferredRegister.create((IForgeRegistry)ForgeRegistries.SOUND_EVENTS, (String)"jagmkiwis");

    public ForgeEntrypoint(FMLJavaModLoadingContext context) {
        KiwiMod.init();
        IEventBus eventBus = context.getModEventBus();
        KiwiModItems.ITEMS_COMMON.forEach((arg_0, arg_1) -> ITEMS_FORGE.register(arg_0, arg_1));
        ENTITIES_FORGE.register("kiwi", KiwiModEntities.KIWI);
        ENTITIES_FORGE.register("laser_beam", KiwiModEntities.LASER_BEAM);
        KiwiModSounds.SOUNDS_COMMON.forEach((arg_0, arg_1) -> SOUNDS_FORGE.register(arg_0, arg_1));
        ITEMS_FORGE.register(eventBus);
        ENTITIES_FORGE.register(eventBus);
        SOUNDS_FORGE.register(eventBus);
    }

    @Mod.EventBusSubscriber(modid="jagmkiwis", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEventHandler {
        @SubscribeEvent
        public static void onRegisterRenderers(EntityRenderersEvent.RegisterRenderers event) {
            event.registerEntityRenderer((EntityType)KiwiModEntities.KIWI.get(), KiwiRenderer::new);
            event.registerEntityRenderer((EntityType)KiwiModEntities.LASER_BEAM.get(), LaserBeamRenderer::new);
        }

        @SubscribeEvent
        public static void onRegisterLayers(EntityRenderersEvent.RegisterLayerDefinitions event) {
            event.registerLayerDefinition(KiwiModel.KIWI_LAYER, KiwiModel::createBodyLayer);
        }

        @SubscribeEvent
        public static void onFillCreativeTabs(BuildCreativeModeTabContentsEvent event) {
            if (event.getTabKey() == CreativeModeTabs.FOOD_AND_DRINKS) {
                event.accept((ItemLike)KiwiModItems.KIWI_FRUIT.get());
                event.accept((ItemLike)KiwiModItems.PAVLOVA.get());
            } else if (event.getTabKey() == CreativeModeTabs.SPAWN_EGGS) {
                event.accept((ItemLike)KiwiModItems.KIWI_SPAWN_EGG.get());
            } else if (event.getTabKey() == CreativeModeTabs.INGREDIENTS) {
                event.accept((ItemLike)KiwiModItems.KIWI_EGG.get());
            } else if (event.getTabKey() == CreativeModeTabs.COMBAT) {
                event.accept((ItemLike)KiwiModItems.KIWI_EGG.get());
            }
        }
    }

    @Mod.EventBusSubscriber(modid="jagmkiwis", bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class CommonGameEventHandler {
        @SubscribeEvent
        public static void onEntityJoinLevel(EntityJoinLevelEvent event) {
            Entity entity = event.getEntity();
            if (entity instanceof Cat) {
                Cat cat = (Cat)entity;
                KiwiModEntities.addCatGoal(cat, cat.targetSelector);
            }
        }
    }

    @Mod.EventBusSubscriber(modid="jagmkiwis", bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class CommonModEventHandler {
        @SubscribeEvent
        public static void createDefaultAttributes(EntityAttributeCreationEvent event) {
            event.put((EntityType)KiwiModEntities.KIWI.get(), KiwiEntity.createAttributes().build());
        }

        @SubscribeEvent
        public static void onRegisterSpawnPlacements(SpawnPlacementRegisterEvent event) {
            event.register((EntityType)KiwiModEntities.KIWI.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Animal::checkAnimalSpawnRules, SpawnPlacementRegisterEvent.Operation.REPLACE);
        }
    }
}

