/*
 * Decompiled with CFR 0.152.
 */
package jagm.jagmkiwis;

import jagm.jagmkiwis.KiwiEntity;
import jagm.jagmkiwis.KiwiModEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileDeflection;
import net.minecraft.world.entity.projectile.ThrownEgg;
import net.minecraft.world.item.EggItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;

public class KiwiEggItem
extends EggItem {
    public KiwiEggItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult use(Level level, Player player, InteractionHand hand) {
        ItemStack itemstack = player.getItemInHand(hand);
        level.playSound((Player)null, player.getX(), player.getY(), player.getZ(), SoundEvents.EGG_THROW, SoundSource.PLAYERS, 0.5f, 0.4f / (level.getRandom().nextFloat() * 0.4f + 0.8f));
        if (level instanceof ServerLevel) {
            ServerLevel serverlevel = (ServerLevel)level;
            Projectile.spawnProjectileFromRotation((level1, owner, itemstack1) -> new ThrownEgg(this, (Level)level1, owner, itemstack1){

                protected void onHit(HitResult result) {
                    HitResult.Type hitresult$type = result.getType();
                    if (hitresult$type == HitResult.Type.ENTITY) {
                        EntityHitResult entityhitresult = (EntityHitResult)result;
                        Entity entity = entityhitresult.getEntity();
                        if (entity.getType().is(EntityTypeTags.REDIRECTABLE_PROJECTILE) && entity instanceof Projectile) {
                            Projectile projectile = (Projectile)entity;
                            projectile.deflect(ProjectileDeflection.AIM_DEFLECT, this.getOwner(), this.getOwner(), true);
                        }
                        this.onHitEntity(entityhitresult);
                        this.level().gameEvent((Holder)GameEvent.PROJECTILE_LAND, result.getLocation(), GameEvent.Context.of((Entity)this, null));
                    } else if (hitresult$type == HitResult.Type.BLOCK) {
                        BlockHitResult blockhitresult = (BlockHitResult)result;
                        this.onHitBlock(blockhitresult);
                        BlockPos blockpos = blockhitresult.getBlockPos();
                        this.level().gameEvent((Holder)GameEvent.PROJECTILE_LAND, blockpos, GameEvent.Context.of((Entity)this, (BlockState)this.level().getBlockState(blockpos)));
                    }
                    if (!this.level().isClientSide) {
                        if (this.random.nextInt(8) == 0) {
                            int i = 1;
                            if (this.random.nextInt(32) == 0) {
                                i = 4;
                            }
                            for (int j = 0; j < i; ++j) {
                                KiwiEntity kiwi = (KiwiEntity)((EntityType)KiwiModEntities.KIWI.get()).create(this.level(), EntitySpawnReason.TRIGGERED);
                                if (kiwi == null) continue;
                                kiwi.setAge(-24000);
                                kiwi.moveTo(this.getX(), this.getY(), this.getZ(), this.getYRot(), 0.0f);
                                if (!kiwi.fudgePositionAfterSizeChange(EntityDimensions.fixed((float)0.0f, (float)0.0f))) break;
                                this.level().addFreshEntity((Entity)kiwi);
                            }
                        }
                        this.level().broadcastEntityEvent((Entity)this, (byte)3);
                        this.discard();
                    }
                }
            }, (ServerLevel)serverlevel, (ItemStack)itemstack, (LivingEntity)player, (float)0.0f, (float)0.25f, (float)1.0f);
        }
        player.awardStat(Stats.ITEM_USED.get((Object)this));
        itemstack.consume(1, (LivingEntity)player);
        return InteractionResult.SUCCESS;
    }
}

