/*
 * Decompiled with CFR 0.152.
 */
package jagm.jagmkiwis;

import jagm.jagmkiwis.KiwiEntity;
import jagm.jagmkiwis.KiwiModel;
import jagm.jagmkiwis.KiwiRenderState;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.entity.AgeableMobRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;

public class KiwiRenderer
extends AgeableMobRenderer<KiwiEntity, KiwiRenderState, KiwiModel> {
    private static final ResourceLocation NORMAL_KIWI = ResourceLocation.fromNamespaceAndPath((String)"jagmkiwis", (String)"textures/entity/kiwi.png");
    private static final ResourceLocation LASER_KIWI = ResourceLocation.fromNamespaceAndPath((String)"jagmkiwis", (String)"textures/entity/laser_kiwi.png");

    public KiwiRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new KiwiModel(context.bakeLayer(KiwiModel.KIWI_LAYER)), (EntityModel)new KiwiModel(context.bakeLayer(KiwiModel.BABY_KIWI_LAYER)), 0.3f);
    }

    public KiwiRenderState createRenderState() {
        return new KiwiRenderState();
    }

    public ResourceLocation getTextureLocation(KiwiRenderState renderState) {
        return renderState.texture;
    }

    public void extractRenderState(KiwiEntity kiwi, KiwiRenderState renderState, float partialTicks) {
        renderState.headEatPositionScale = 17.5f + kiwi.getHeadEatPositionScale(partialTicks);
        renderState.headEatAngleScale = kiwi.getHeadEatAngleScale(partialTicks);
        renderState.texture = kiwi.getVariant() == KiwiEntity.Variant.LASER ? LASER_KIWI : NORMAL_KIWI;
        super.extractRenderState((LivingEntity)kiwi, (LivingEntityRenderState)renderState, partialTicks);
    }
}

