/*
 * Decompiled with CFR 0.152.
 */
package jagm.jagmkiwis;

import jagm.jagmkiwis.KiwiModEntities;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;

public class LaserBeamEntity
extends AbstractArrow {
    protected LaserBeamEntity(EntityType<? extends AbstractArrow> entityType, Level level) {
        super(entityType, level);
    }

    protected LaserBeamEntity(Level level, LivingEntity shooter) {
        super((EntityType)KiwiModEntities.LASER_BEAM.get(), level);
        this.setOwner((Entity)shooter);
    }

    protected ItemStack getDefaultPickupItem() {
        return new ItemStack((ItemLike)Items.ARROW);
    }

    public boolean isNoGravity() {
        return true;
    }

    protected void onHitBlock(BlockHitResult hitResult) {
        BlockState blockstate = this.level().getBlockState(hitResult.getBlockPos());
        blockstate.onProjectileHit(this.level(), blockstate, hitResult, (Projectile)this);
        this.discard();
    }

    protected void onHitEntity(EntityHitResult hitResult) {
        DamageSource damagesource;
        Entity shooter;
        Entity target = hitResult.getEntity();
        float f = (float)this.getDeltaMovement().length();
        double baseDamage = 4.0;
        int i = Mth.ceil((double)Mth.clamp((double)((double)f * baseDamage), (double)0.0, (double)2.147483647E9));
        if (this.isCritArrow()) {
            long j = this.random.nextInt(i / 2 + 2);
            i = (int)Math.min(j + (long)i, Integer.MAX_VALUE);
        }
        if ((shooter = this.getOwner()) == null) {
            damagesource = this.damageSources().arrow((AbstractArrow)this, (Entity)this);
        } else {
            damagesource = this.damageSources().arrow((AbstractArrow)this, shooter);
            if (shooter instanceof LivingEntity) {
                ((LivingEntity)shooter).setLastHurtMob(target);
            }
        }
        Level level = this.level();
        if (level instanceof ServerLevel) {
            boolean flag;
            ServerLevel serverLevel = (ServerLevel)level;
            boolean bl = flag = target.getType() == EntityType.ENDERMAN;
            if (target.hurtServer(serverLevel, damagesource, (float)i)) {
                if (flag) {
                    return;
                }
                if (target instanceof LivingEntity) {
                    LivingEntity livingEntity = (LivingEntity)target;
                    if (shooter instanceof LivingEntity) {
                        EnchantmentHelper.doPostAttackEffects((ServerLevel)serverLevel, (Entity)target, (DamageSource)damagesource);
                    }
                    this.doPostHurtEffects(livingEntity);
                }
            }
        }
        this.discard();
    }

    public void tick() {
        super.tick();
        if (this.getDeltaMovement().length() < 1.0) {
            this.discard();
        }
    }
}

