/*
 * Decompiled with CFR 0.152.
 */
package jagm.jagmkiwis;

import jagm.jagmkiwis.KiwiEntity;
import jagm.jagmkiwis.KiwiMod;
import jagm.jagmkiwis.KiwiModEntities;
import jagm.jagmkiwis.KiwiModItems;
import jagm.jagmkiwis.KiwiModSounds;
import jagm.jagmkiwis.KiwiModel;
import jagm.jagmkiwis.KiwiRenderer;
import jagm.jagmkiwis.LaserBeamRenderer;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.SpawnPlacementTypes;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Cat;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.levelgen.Heightmap;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import net.neoforged.neoforge.registries.DeferredRegister;

@Mod(value="jagmkiwis")
public class NeoforgeEntrypoint {
    static final DeferredRegister.Items ITEMS_NEOFORGE = DeferredRegister.createItems((String)"jagmkiwis");
    static final DeferredRegister<EntityType<?>> ENTITIES_NEOFORGE = DeferredRegister.create((ResourceKey)Registries.ENTITY_TYPE, (String)"jagmkiwis");
    static final DeferredRegister<SoundEvent> SOUNDS_NEOFORGE = DeferredRegister.create((ResourceKey)Registries.SOUND_EVENT, (String)"jagmkiwis");

    public NeoforgeEntrypoint(IEventBus eventBus) {
        KiwiMod.init();
        KiwiModItems.ITEMS_COMMON.forEach((arg_0, arg_1) -> ((DeferredRegister.Items)ITEMS_NEOFORGE).register(arg_0, arg_1));
        ENTITIES_NEOFORGE.register("kiwi", KiwiModEntities.KIWI);
        ENTITIES_NEOFORGE.register("laser_beam", KiwiModEntities.LASER_BEAM);
        KiwiModSounds.SOUNDS_COMMON.forEach((arg_0, arg_1) -> SOUNDS_NEOFORGE.register(arg_0, arg_1));
        ITEMS_NEOFORGE.register(eventBus);
        ENTITIES_NEOFORGE.register(eventBus);
        SOUNDS_NEOFORGE.register(eventBus);
    }

    @EventBusSubscriber(modid="jagmkiwis", bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEventHandler {
        @SubscribeEvent
        public static void onRegisterRenderers(EntityRenderersEvent.RegisterRenderers event) {
            event.registerEntityRenderer((EntityType)KiwiModEntities.KIWI.get(), KiwiRenderer::new);
            event.registerEntityRenderer((EntityType)KiwiModEntities.LASER_BEAM.get(), LaserBeamRenderer::new);
        }

        @SubscribeEvent
        public static void onRegisterLayers(EntityRenderersEvent.RegisterLayerDefinitions event) {
            event.registerLayerDefinition(KiwiModel.KIWI_LAYER, KiwiModel::createBodyLayer);
            event.registerLayerDefinition(KiwiModel.BABY_KIWI_LAYER, () -> KiwiModel.createBodyLayer().apply(KiwiModel.BABY_TRANSFORMER));
        }

        @SubscribeEvent
        public static void onFillCreativeTabs(BuildCreativeModeTabContentsEvent event) {
            if (event.getTabKey() == CreativeModeTabs.FOOD_AND_DRINKS) {
                event.accept((ItemLike)KiwiModItems.KIWI_FRUIT.get());
                event.accept((ItemLike)KiwiModItems.PAVLOVA.get());
            } else if (event.getTabKey() == CreativeModeTabs.SPAWN_EGGS) {
                event.accept((ItemLike)KiwiModItems.KIWI_SPAWN_EGG.get());
            } else if (event.getTabKey() == CreativeModeTabs.INGREDIENTS) {
                event.accept((ItemLike)KiwiModItems.KIWI_EGG.get());
            } else if (event.getTabKey() == CreativeModeTabs.COMBAT) {
                event.accept((ItemLike)KiwiModItems.KIWI_EGG.get());
            }
        }
    }

    @EventBusSubscriber(modid="jagmkiwis", bus=EventBusSubscriber.Bus.GAME)
    public static class CommonGameEventHandler {
        @SubscribeEvent
        public static void onEntityJoinLevel(EntityJoinLevelEvent event) {
            Entity entity = event.getEntity();
            if (entity instanceof Cat) {
                Cat cat = (Cat)entity;
                KiwiModEntities.addCatGoal(cat, cat.targetSelector);
            }
        }
    }

    @EventBusSubscriber(modid="jagmkiwis", bus=EventBusSubscriber.Bus.MOD)
    public static class CommonModEventHandler {
        @SubscribeEvent
        public static void createDefaultAttributes(EntityAttributeCreationEvent event) {
            event.put((EntityType)KiwiModEntities.KIWI.get(), KiwiEntity.createAttributes().build());
        }

        @SubscribeEvent
        public static void onRegisterSpawnPlacements(RegisterSpawnPlacementsEvent event) {
            event.register((EntityType)KiwiModEntities.KIWI.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Animal::checkAnimalSpawnRules, RegisterSpawnPlacementsEvent.Operation.REPLACE);
        }
    }
}

