/*
 * Decompiled with CFR 0.152.
 */
package jagm.jagmkiwis;

import jagm.jagmkiwis.KiwiEntity;
import jagm.jagmkiwis.KiwiModEntities;
import jagm.jagmkiwis.KiwiModItems;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;

public class KiwiEggEntity
extends ThrowableItemProjectile {
    public KiwiEggEntity(EntityType<? extends KiwiEggEntity> kiwiEgg, Level level) {
        super(kiwiEgg, level);
    }

    public KiwiEggEntity(Level level, LivingEntity owner, ItemStack stack) {
        super(KiwiModEntities.KIWI_EGG, owner, level, stack);
    }

    public KiwiEggEntity(Level level, double x, double y, double z, ItemStack item) {
        super(KiwiModEntities.KIWI_EGG, x, y, z, level, item);
    }

    public void handleEntityEvent(byte id) {
        if (id == 3) {
            for (int i = 0; i < 8; ++i) {
                this.level().addParticle((ParticleOptions)new ItemParticleOption(ParticleTypes.ITEM, this.getItem()), this.getX(), this.getY(), this.getZ(), ((double)this.random.nextFloat() - 0.5) * 0.08, ((double)this.random.nextFloat() - 0.5) * 0.08, ((double)this.random.nextFloat() - 0.5) * 0.08);
            }
        }
    }

    protected void onHitEntity(EntityHitResult result) {
        super.onHitEntity(result);
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            result.getEntity().hurtServer(serverLevel, this.damageSources().thrown((Entity)this, this.getOwner()), 0.0f);
        }
    }

    protected void onHit(HitResult result) {
        super.onHit(result);
        if (!this.level().isClientSide()) {
            if (this.random.nextInt(8) == 0) {
                int i = 1;
                if (this.random.nextInt(32) == 0) {
                    i = 4;
                }
                for (int j = 0; j < i; ++j) {
                    KiwiEntity kiwi = (KiwiEntity)KiwiModEntities.KIWI.create(this.level(), EntitySpawnReason.TRIGGERED);
                    if (kiwi == null) continue;
                    kiwi.setAge(-24000);
                    kiwi.snapTo(this.getX(), this.getY(), this.getZ(), this.getYRot(), 0.0f);
                    if (!kiwi.fudgePositionAfterSizeChange(EntityDimensions.fixed((float)0.0f, (float)0.0f))) break;
                    this.level().addFreshEntity((Entity)kiwi);
                }
            }
            this.level().broadcastEntityEvent((Entity)this, (byte)3);
            this.discard();
        }
    }

    protected Item getDefaultItem() {
        return KiwiModItems.KIWI_EGG;
    }
}

