/*
 * Decompiled with CFR 0.152.
 */
package jagm.jagmkiwis;

import jagm.jagmkiwis.KiwiEggEntity;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileItem;
import net.minecraft.world.level.Level;

public class KiwiEggItem
extends Item
implements ProjectileItem {
    public KiwiEggItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        level.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.EGG_THROW, SoundSource.PLAYERS, 0.5f, 0.4f / (level.getRandom().nextFloat() * 0.4f + 0.8f));
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            Projectile.spawnProjectileFromRotation(KiwiEggEntity::new, (ServerLevel)serverLevel, (ItemStack)stack, (LivingEntity)player, (float)0.0f, (float)0.25f, (float)1.0f);
        }
        player.awardStat(Stats.ITEM_USED.get((Object)this));
        stack.consume(1, (LivingEntity)player);
        return InteractionResult.SUCCESS;
    }

    public Projectile asProjectile(Level level, Position pos, ItemStack stack, Direction direction) {
        return new KiwiEggEntity(level, pos.x(), pos.y(), pos.z(), stack);
    }
}

