/*
 * Decompiled with CFR 0.152.
 */
package jagm.jagmkiwis;

import jagm.jagmkiwis.KiwiDigGoal;
import jagm.jagmkiwis.KiwiModEntities;
import jagm.jagmkiwis.KiwiModItems;
import jagm.jagmkiwis.KiwiModSounds;
import jagm.jagmkiwis.LaserBeamEntity;
import java.util.Optional;
import java.util.function.IntFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.Mth;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Cat;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3;

public class KiwiEntity
extends Animal
implements RangedAttackMob {
    private static final EntityDataAccessor<Integer> DATA_TYPE_ID = SynchedEntityData.defineId(KiwiEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final int CHANCE_OF_LASERS = 5;
    private static final EntityDimensions BABY_DIMENSIONS = KiwiModEntities.KIWI.getDimensions().scale(0.75f).withEyeHeight(0.25f);
    private KiwiDigGoal digGoal;
    private int digAnimationTick;
    public int eggTime;
    public boolean isKiwiJockey;

    protected KiwiEntity(EntityType<? extends Animal> entityType, Level world) {
        super(entityType, world);
        this.eggTime = this.random.nextInt(12000) + 12000;
        this.isKiwiJockey = false;
    }

    protected void registerGoals() {
        this.digGoal = new KiwiDigGoal((Mob)this);
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(2, (Goal)new BreedGoal((Animal)this, 1.0));
        this.goalSelector.addGoal(3, (Goal)new TemptGoal((PathfinderMob)this, 1.0, stack -> stack.is(ItemTags.CHICKEN_FOOD), false));
        this.goalSelector.addGoal(4, (Goal)new FollowParentGoal((Animal)this, 1.1));
        this.goalSelector.addGoal(5, (Goal)new AvoidEntityGoal((PathfinderMob)this, Cat.class, 8.0f, 1.0, 1.0));
        this.goalSelector.addGoal(6, (Goal)this.digGoal);
        this.goalSelector.addGoal(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(8, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    protected void customServerAiStep(ServerLevel level) {
        this.digAnimationTick = this.digGoal.getDigAnimationTick();
        super.customServerAiStep(level);
    }

    public void aiStep() {
        Level level;
        if (this.level().isClientSide()) {
            this.digAnimationTick = Math.max(0, this.digAnimationTick - 1);
        }
        if ((level = this.level()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.isAlive() && !this.isBaby() && !this.isKiwiJockey && --this.eggTime <= 0) {
                this.playSound(KiwiModSounds.KIWI_LAY_EGG, 1.0f, (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f);
                this.spawnAtLocation(serverLevel, (ItemLike)KiwiModItems.KIWI_EGG);
                this.gameEvent((Holder)GameEvent.ENTITY_PLACE);
                this.eggTime = this.random.nextInt(12000) + 12000;
            }
        }
        super.aiStep();
    }

    public boolean isFood(ItemStack stack) {
        return stack.is(ItemTags.CHICKEN_FOOD);
    }

    public void handleEntityEvent(byte id) {
        if (id == 10) {
            this.digAnimationTick = 40;
        } else {
            super.handleEntityEvent(id);
        }
    }

    public float getHeadEatPositionScale(float partialTicks) {
        if (this.digAnimationTick <= 0) {
            return 0.0f;
        }
        if (this.digAnimationTick >= 4 && this.digAnimationTick <= 36) {
            return 1.0f;
        }
        return this.digAnimationTick < 4 ? ((float)this.digAnimationTick - partialTicks) / 4.0f : -((float)(this.digAnimationTick - 40) - partialTicks) / 4.0f;
    }

    public float getHeadEatAngleScale(float partialTicks) {
        if (this.digAnimationTick > 4 && this.digAnimationTick <= 36) {
            float f = ((float)(this.digAnimationTick - 4) - partialTicks) / 32.0f;
            return 0.62831855f + 0.21991149f * Mth.sin((float)(f * 28.7f));
        }
        return this.digAnimationTick > 0 ? 0.62831855f : this.getXRot() * ((float)Math.PI / 180);
    }

    public KiwiEntity getBreedOffspring(ServerLevel world, AgeableMob kiwi) {
        boolean isLaserVariant;
        KiwiEntity babyKiwi = (KiwiEntity)KiwiModEntities.KIWI.create((Level)world, EntitySpawnReason.BREEDING);
        boolean bl = isLaserVariant = this.getRandom().nextInt(100) < 5;
        if (babyKiwi != null) {
            babyKiwi.setVariant(isLaserVariant ? Variant.LASER : Variant.NORMAL);
        }
        return babyKiwi;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Animal.createAnimalAttributes().add(Attributes.ATTACK_DAMAGE, 3.0).add(Attributes.MAX_HEALTH, 5.0).add(Attributes.MOVEMENT_SPEED, 0.35).add(Attributes.FOLLOW_RANGE, 40.0);
    }

    protected SoundEvent getAmbientSound() {
        return KiwiModSounds.KIWI_AMBIENT;
    }

    public void playAmbientSound() {
        if (this.level().dimensionType().hasFixedTime() || this.level().isDarkOutside()) {
            super.playAmbientSound();
        }
    }

    protected SoundEvent getHurtSound(DamageSource damageSource) {
        return KiwiModSounds.KIWI_HURT;
    }

    protected SoundEvent getDeathSound() {
        return KiwiModSounds.KIWI_DEATH;
    }

    protected void playStepSound(BlockPos pos, BlockState blockState) {
        this.playSound(SoundEvents.CHICKEN_STEP, 0.15f, 1.0f);
    }

    protected float getSoundVolume() {
        return 0.3f;
    }

    public int getAmbientSoundInterval() {
        return 160;
    }

    private void setVariant(Variant variant) {
        if (variant == Variant.LASER) {
            this.getAttribute(Attributes.ARMOR).setBaseValue(8.0);
            this.goalSelector.addGoal(3, (Goal)new RangedAttackGoal((RangedAttackMob)this, 1.0, 20, 40, 20.0f));
            this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
            this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Monster.class, true, (target, level) -> !(target instanceof Creeper)));
        } else {
            this.goalSelector.addGoal(1, (Goal)new PanicGoal((PathfinderMob)this, 1.0));
        }
        this.entityData.set(DATA_TYPE_ID, (Object)variant.id);
    }

    public Variant getVariant() {
        return Variant.byId((Integer)this.entityData.get(DATA_TYPE_ID));
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_TYPE_ID, (Object)Variant.NORMAL.id);
    }

    public void addAdditionalSaveData(ValueOutput valueOutput) {
        super.addAdditionalSaveData(valueOutput);
        valueOutput.putBoolean("IsKiwiJockey", this.isKiwiJockey);
        valueOutput.putInt("EggLayTime", this.eggTime);
        valueOutput.putInt("KiwiType", this.getVariant().id);
    }

    public void readAdditionalSaveData(ValueInput valueInput) {
        super.readAdditionalSaveData(valueInput);
        this.isKiwiJockey = valueInput.getBooleanOr("IsKiwiJockey", false);
        valueInput.getInt("EggLayTime").ifPresent(eggTime -> {
            this.eggTime = eggTime;
        });
        Optional id = valueInput.getInt("KiwiType");
        this.setVariant(id.isPresent() ? Variant.byId((Integer)id.get()) : Variant.NORMAL);
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor levelAccessor, DifficultyInstance difficulty, EntitySpawnReason spawnReason, SpawnGroupData spawnGroupData) {
        boolean isLaserVariant = levelAccessor.getRandom().nextInt(100) < 5;
        this.setVariant(isLaserVariant ? Variant.LASER : Variant.NORMAL);
        return super.finalizeSpawn(levelAccessor, difficulty, spawnReason, spawnGroupData);
    }

    public void performRangedAttack(LivingEntity target, float velocity) {
        LaserBeamEntity laser = new LaserBeamEntity(this.level(), (LivingEntity)this);
        double d0 = target.getX() - this.getX();
        double d1 = target.getEyeY() - this.getEyeY();
        double d2 = target.getZ() - this.getZ();
        laser.setPos(new Vec3(this.getX(), this.getEyeY(), this.getZ()).add(new Vec3(d0, d1, d2).normalize()));
        laser.shoot(d0, d1, d2, 1.5f, 0.0f);
        this.level().addFreshEntity((Entity)laser);
        if (!this.isSilent()) {
            this.playSound(KiwiModSounds.LASER_SHOOT);
        }
    }

    public EntityDimensions getDefaultDimensions(Pose pose) {
        return this.isBaby() ? BABY_DIMENSIONS : super.getDefaultDimensions(pose);
    }

    protected Vec3 getPassengerAttachmentPoint(Entity passenger, EntityDimensions size, float partialTicks) {
        Vec3 offset = new Vec3(0.0, 0.0, -0.1875);
        return super.getPassengerAttachmentPoint(passenger, size, partialTicks).add(offset.yRot(-this.yBodyRot * (float)Math.PI / 180.0f));
    }

    protected void positionRider(Entity passenger, Entity.MoveFunction moveFunction) {
        super.positionRider(passenger, moveFunction);
        if (passenger instanceof LivingEntity) {
            LivingEntity livingPassenger = (LivingEntity)passenger;
            livingPassenger.yBodyRot = this.yBodyRot;
        }
    }

    public boolean removeWhenFarAway(double distanceToClosestPlayer) {
        return this.isKiwiJockey;
    }

    public static enum Variant implements StringRepresentable
    {
        NORMAL(0, "normal"),
        LASER(99, "laser");

        private static final IntFunction<Variant> BY_ID;
        final int id;
        private final String name;

        private Variant(int id, String name) {
            this.id = id;
            this.name = name;
        }

        public String getSerializedName() {
            return this.name;
        }

        public int id() {
            return this.id;
        }

        public static Variant byId(int id) {
            return BY_ID.apply(id);
        }

        static {
            BY_ID = ByIdMap.sparse(Variant::id, (Object[])Variant.values(), (Object)((Object)NORMAL));
        }
    }
}

