/*
 * Decompiled with CFR 0.152.
 */
package jagm.jagmkiwis;

import jagm.jagmkiwis.KiwiEggEntity;
import jagm.jagmkiwis.KiwiEntity;
import jagm.jagmkiwis.LaserBeamEntity;
import java.util.List;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.GoalSelector;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.Cat;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.level.ServerLevelAccessor;

public class KiwiModEntities {
    public static final String KIWI_NAME = "kiwi";
    public static final String LASER_BEAM_NAME = "laser_beam";
    public static final String KIWI_EGG_NAME = "kiwi_egg";
    public static final float KIWI_JOCKEY_CHANCE = 0.05f;
    public static final EntityType<KiwiEntity> KIWI = EntityType.Builder.of(KiwiEntity::new, (MobCategory)MobCategory.CREATURE).clientTrackingRange(8).sized(0.5f, 0.5f).build(ResourceKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"jagmkiwis", (String)"kiwi")));
    public static final EntityType<LaserBeamEntity> LASER_BEAM = EntityType.Builder.of(LaserBeamEntity::new, (MobCategory)MobCategory.MISC).noLootTable().updateInterval(20).sized(0.5f, 0.5f).build(ResourceKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"jagmkiwis", (String)"laser_beam")));
    public static final EntityType<KiwiEggEntity> KIWI_EGG = EntityType.Builder.of(KiwiEggEntity::new, (MobCategory)MobCategory.MISC).noLootTable().updateInterval(20).sized(0.25f, 0.25f).build(ResourceKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"jagmkiwis", (String)"kiwi_egg")));

    public static void addCatGoal(Cat cat, GoalSelector targetSelector) {
        targetSelector.addGoal(1, (Goal)new NearestAttackableTargetGoal((Mob)cat, KiwiEntity.class, true));
    }

    public static SpawnGroupData finalizeZombieSpawn(Zombie zombie, ServerLevelAccessor level, SpawnGroupData spawnGroupData, DifficultyInstance difficulty) {
        RandomSource random = level.getRandom();
        if (spawnGroupData == null) {
            spawnGroupData = new Zombie.ZombieGroupData(Zombie.getSpawnAsBabyOdds((RandomSource)random), true);
        }
        if (spawnGroupData instanceof Zombie.ZombieGroupData) {
            Zombie.ZombieGroupData zombieGroupData = (Zombie.ZombieGroupData)spawnGroupData;
            if (zombieGroupData.isBaby && zombieGroupData.canSpawnJockey) {
                KiwiEntity kiwi;
                if (random.nextFloat() < 0.05f) {
                    List list = level.getEntitiesOfClass(KiwiEntity.class, zombie.getBoundingBox().inflate(5.0, 3.0, 5.0), EntitySelector.ENTITY_NOT_BEING_RIDDEN);
                    if (!list.isEmpty()) {
                        KiwiEntity kiwi2 = (KiwiEntity)((Object)list.getFirst());
                        kiwi2.isKiwiJockey = true;
                        zombie.startRiding((Entity)kiwi2);
                        return new Zombie.ZombieGroupData(true, false);
                    }
                } else if (random.nextFloat() < 0.05f && (kiwi = (KiwiEntity)KIWI.create(zombie.level(), EntitySpawnReason.JOCKEY)) != null) {
                    kiwi.snapTo(zombie.getX(), zombie.getY(), zombie.getZ(), zombie.getYRot(), 0.0f);
                    kiwi.finalizeSpawn(level, difficulty, EntitySpawnReason.JOCKEY, null);
                    kiwi.isKiwiJockey = true;
                    zombie.startRiding((Entity)kiwi);
                    level.addFreshEntity((Entity)kiwi);
                    return new Zombie.ZombieGroupData(true, false);
                }
            }
        }
        return spawnGroupData;
    }
}

