/*
 * Decompiled with CFR 0.152.
 */
package jagm.jagmkiwis;

import jagm.jagmkiwis.KiwiRenderState;
import java.util.Set;
import net.minecraft.client.model.BabyModelTransform;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.MeshTransformer;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class KiwiModel
extends EntityModel<KiwiRenderState> {
    public static final ModelLayerLocation KIWI_LAYER = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"jagmkiwis", (String)"kiwi"), "main");
    public static final ModelLayerLocation BABY_KIWI_LAYER = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"jagmkiwis", (String)"baby_kiwi"), "main");
    public static final MeshTransformer BABY_TRANSFORMER = new BabyModelTransform(false, 2.0f, 0.5f, Set.of("head"));
    private final ModelPart head;
    private final ModelPart leftLeg;
    private final ModelPart rightLeg;
    private final ModelPart body;

    public KiwiModel(ModelPart root) {
        super(root);
        this.head = root.getChild("head");
        this.leftLeg = root.getChild("left_leg");
        this.rightLeg = root.getChild("right_leg");
        this.body = root.getChild("body");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 10).addBox(-2.0f, -1.5f, -3.0f, 3.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(12, 10).addBox(-1.0f, -0.5f, -7.0f, 1.0f, 1.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.5f, (float)17.5f, (float)-1.0f));
        partdefinition.addOrReplaceChild("left_leg", CubeListBuilder.create().texOffs(15, 0).addBox(-1.5f, -1.0f, -1.0f, 2.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(23, 0).addBox(-1.0f, 1.5f, -0.5f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(21, 3).addBox(-2.0f, 3.5f, -2.5f, 3.0f, 0.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)3.0f, (float)20.5f, (float)2.0f));
        partdefinition.addOrReplaceChild("right_leg", CubeListBuilder.create().texOffs(15, 0).addBox(-1.5f, -1.0f, -1.0f, 2.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(23, 0).addBox(-1.0f, 1.5f, -0.5f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(21, 3).addBox(-2.0f, 3.5f, -2.5f, 3.0f, 0.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-2.0f, (float)20.5f, (float)2.0f));
        partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 0).addBox(-3.0f, -2.5f, -2.5f, 5.0f, 5.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.5f, (float)19.5f, (float)1.5f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)32, (int)32);
    }

    public void setupAnim(KiwiRenderState renderState) {
        super.setupAnim((Object)renderState);
        this.head.y = renderState.headEatPositionScale + (renderState.isBaby ? 2.0f : 0.0f);
        this.head.xRot = renderState.headEatAngleScale;
        this.head.yRot = renderState.yRot * ((float)Math.PI / 180);
        this.rightLeg.xRot = Mth.cos((float)(renderState.walkAnimationPos * 0.6662f)) * 1.4f * renderState.walkAnimationSpeed;
        this.leftLeg.xRot = Mth.cos((float)(renderState.walkAnimationPos * 0.6662f + (float)Math.PI)) * 1.4f * renderState.walkAnimationSpeed;
    }
}

