/*
 * Decompiled with CFR 0.152.
 */
package net.xstopho.resourcelibrary.registration;

import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackLocationInfo;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackSelectionConfig;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.PathPackResources;
import net.minecraft.server.packs.repository.KnownPack;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.AddPackFindersEvent;
import net.minecraftforge.eventbus.api.listener.SubscribeEvent;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.forgespi.language.IModInfo;
import net.xstopho.resourcelibrary.LibConstants;
import net.xstopho.resourcelibrary.registration.ResourcePackRegistry;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.jetbrains.annotations.NotNull;

@Mod.EventBusSubscriber(modid="resourcelibrary", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class ForgeResourcePackRegistry
implements ResourcePackRegistry {
    private String modId;
    private static final Map<ResourceLocation, Component> RESOURCE_PACKS = new HashMap<ResourceLocation, Component>();

    @Override
    public ResourcePackRegistry setModId(String modId) {
        this.modId = modId;
        return this;
    }

    @Override
    public String getModId() {
        return this.modId;
    }

    @Override
    public void register(@NotNull ResourceLocation packLocation, @NotNull String packDisplayName) {
        ResourceLocation packPath = ResourceLocation.fromNamespaceAndPath((String)packLocation.getNamespace(), (String)("resourcepacks/" + packLocation.getPath()));
        if (!RESOURCE_PACKS.containsKey(packPath)) {
            RESOURCE_PACKS.put(packPath, (Component)Component.literal((String)packDisplayName));
        } else {
            LibConstants.LOG.error("Resourcepack '{}' with location '{}' is already registered!", (Object)packDisplayName, (Object)packLocation);
        }
    }

    @SubscribeEvent
    public static void registerResourcePacks(AddPackFindersEvent event) {
        if (event.getPackType() == PackType.CLIENT_RESOURCES) {
            RESOURCE_PACKS.forEach((location, component) -> {
                IModInfo modInfo = ((ModContainer)ModList.get().getModContainerById(location.getNamespace()).orElseThrow(() -> new IllegalArgumentException("Mod not found: " + location.getNamespace()))).getModInfo();
                Path resourcePath = modInfo.getOwningFile().getFile().findResource(new String[]{location.getPath()});
                ArtifactVersion version = modInfo.getVersion();
                Pack pack = Pack.readMetaAndCreate((PackLocationInfo)new PackLocationInfo("mod/" + String.valueOf(location), component, PackSource.BUILT_IN, Optional.of(new KnownPack("forge", "mod/" + String.valueOf(location), version.toString()))), (Pack.ResourcesSupplier)ForgeResourcePackRegistry.fromName(packLocationInfo -> new PathPackResources(packLocationInfo, resourcePath)), (PackType)PackType.CLIENT_RESOURCES, (PackSelectionConfig)new PackSelectionConfig(false, Pack.Position.TOP, false));
                event.addRepositorySource(consumer -> consumer.accept(pack));
                LibConstants.LOG.info("Registered Built-In Resourcepack: {}", (Object)component.getString());
            });
        }
    }

    public static Pack.ResourcesSupplier fromName(final Function<PackLocationInfo, PackResources> onName) {
        return new Pack.ResourcesSupplier(){

            public PackResources openPrimary(PackLocationInfo packLocationInfo) {
                return (PackResources)onName.apply(packLocationInfo);
            }

            public PackResources openFull(PackLocationInfo packLocationInfo, Pack.Metadata metadata) {
                return (PackResources)onName.apply(packLocationInfo);
            }
        };
    }
}

