/*
 * Decompiled with CFR 0.152.
 */
package net.xstopho.resourcelibrary.mixin.rendering.items;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.HashMap;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.xstopho.resourcelibrary.mixin.rendering.items.ItemRendererAccessor;
import net.xstopho.resourcelibrary.rendering.item.ItemModelRenderHelper;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyVariable;

@Mixin(value={ItemRenderer.class})
public class ItemRendererMixin {
    @ModifyVariable(method={"render"}, at=@At(value="HEAD"), argsOnly=true)
    public BakedModel useInHandModel(BakedModel model, ItemStack stack, ItemDisplayContext displayContext, boolean leftHanded, PoseStack poseStack, MultiBufferSource bufferSource, int light, int overlay) {
        HashMap<Item, ModelResourceLocation> map = ItemModelRenderHelper.getItemModels();
        if (this.isInHand(displayContext) && map.containsKey(stack.getItem())) {
            return this.getModel(map.get(stack.getItem()));
        }
        return model;
    }

    private boolean isInHand(ItemDisplayContext context) {
        return context.firstPerson() || context == ItemDisplayContext.THIRD_PERSON_LEFT_HAND || context == ItemDisplayContext.THIRD_PERSON_RIGHT_HAND;
    }

    private BakedModel getModel(ModelResourceLocation location) {
        return ((ItemRendererAccessor)((Object)this)).lib_getItemModelShaper().getModelManager().getModel(location);
    }
}

