/*
 * Decompiled with CFR 0.152.
 */
package net.xstopho.resourcelibrary.registration;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.javafmlmod.FMLModContainer;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.xstopho.resourcelibrary.registration.RegistryObject;
import net.xstopho.resourcelibrary.registration.RegistryProvider;

public class NeoForgeRegistryFactory
implements RegistryProvider.Factory {
    @Override
    public <T> RegistryProvider<T> create(ResourceKey<? extends Registry<T>> resourceKey, String modId) {
        Optional modContainer = ModList.get().getModContainerById(modId);
        if (modContainer.isEmpty()) {
            throw new NullPointerException("Cannot find Mod Container for " + modId);
        }
        ModContainer container = (ModContainer)modContainer.get();
        if (container instanceof FMLModContainer) {
            FMLModContainer fmlModContainer = (FMLModContainer)container;
            DeferredRegister register = DeferredRegister.create(resourceKey, (String)modId);
            register.register(Objects.requireNonNull(fmlModContainer.getEventBus()));
            return new Provider(register, modId);
        }
        throw new ClassCastException("The Container of the Mod " + modId + " is not a NeoForge one!");
    }

    private static class Provider<T>
    implements RegistryProvider<T> {
        private final String modId;
        private final DeferredRegister<T> registry;
        private final Set<RegistryObject<T>> entries = new LinkedHashSet<RegistryObject<T>>();
        private final Set<RegistryObject<T>> entriesView = Collections.unmodifiableSet(this.entries);

        private Provider(DeferredRegister<T> registry, String modId) {
            this.registry = registry;
            this.modId = modId;
        }

        @Override
        public String getModId() {
            return this.modId;
        }

        @Override
        public <I extends T> RegistryObject<I> register(String name, Supplier<? extends I> supplier) {
            final DeferredHolder object = this.registry.register(name, supplier);
            RegistryObject registryObject = new RegistryObject<I>(){

                @Override
                public ResourceKey<I> getResourceKey() {
                    return object.getKey();
                }

                @Override
                public ResourceLocation getId() {
                    return object.getId();
                }

                @Override
                public I get() {
                    return object.get();
                }

                @Override
                public Holder<I> asHolder() {
                    return object;
                }
            };
            this.entries.add(registryObject);
            return registryObject;
        }

        @Override
        public Set<RegistryObject<T>> getEntries() {
            return this.entriesView;
        }
    }
}

