/*
 * Decompiled with CFR 0.152.
 */
package net.xstopho.resourcelibrary.util;

import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.material.Fluid;
import net.xstopho.resourcelibrary.platform.IPlatformHelper;
import net.xstopho.resourcelibrary.service.CoreServices;

public class TagHelper {
    public static TagKey<Item> createItemTag(String id) {
        return TagHelper.createPlatformTag(Registries.ITEM, id);
    }

    public static TagKey<Block> createBlockTag(String id) {
        return TagHelper.createPlatformTag(Registries.BLOCK, id);
    }

    public static TagKey<Enchantment> createEnchantmentTag(String id) {
        return TagHelper.createPlatformTag(Registries.ENCHANTMENT, id);
    }

    public static TagKey<Fluid> createFluidTag(String id) {
        return TagHelper.createPlatformTag(Registries.FLUID, id);
    }

    public static TagKey<BlockEntityType<?>> createBlockEntityTypeTag(String id) {
        return TagHelper.createPlatformTag(Registries.BLOCK_ENTITY_TYPE, id);
    }

    public static TagKey<EntityType<?>> createEntityTypeTag(String id) {
        return TagHelper.createPlatformTag(Registries.ENTITY_TYPE, id);
    }

    public static <T> TagKey<T> createPlatformTag(ResourceKey<? extends Registry<T>> registry, String id) {
        return switch (CoreServices.getPlatform()) {
            default -> throw new MatchException(null, null);
            case IPlatformHelper.Platforms.FABRIC, IPlatformHelper.Platforms.NEOFORGE -> TagHelper.createTag(registry, "c", id);
            case IPlatformHelper.Platforms.FORGE -> TagHelper.createTag(registry, "forge", id);
            case IPlatformHelper.Platforms.NO_LOADER -> throw new IllegalStateException("No Mod Loader defined or you are in an non Mod Environment!");
        };
    }

    static <T> TagKey<T> createTag(ResourceKey<? extends Registry<T>> registry, String prefix, String id) {
        return TagKey.create(registry, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)prefix, (String)id));
    }
}

