/*
 * Decompiled with CFR 0.152.
 */
package net.xstopho.resourcelibrary.util;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.Level;

public class TreeTrimmingUtil {
    private List<BlockPos> scanned = new ArrayList<BlockPos>();
    private Level level;

    public BlockPos getLastBlock(Level level, BlockPos startPos) {
        this.level = level;
        this.scanned = new ArrayList<BlockPos>();
        return this.scanTree(startPos);
    }

    BlockPos scanTree(BlockPos pos) {
        if (!this.notVisited(pos)) {
            return pos;
        }
        this.scanned.add(pos);
        if (this.hasBlockAbove(pos)) {
            if (this.hasNeighbour(pos) && this.getAllNeighbours(pos).size() >= 3) {
                this.scanned.addAll(this.getAllNeighbours(pos));
            }
            pos = this.scanTree(pos.above());
        }
        if (!this.hasBlockAbove(pos) && this.hasNeighbour(pos)) {
            pos = this.scanTree(this.getFirstNeighbour(pos));
        }
        if (!this.hasBlockAbove(pos) && this.hasDiagonalNeighbour(pos)) {
            pos = this.scanTree(this.getFirstDiagonalNeighbour(pos));
        }
        if (!this.hasBlockAbove(pos) && this.hasBlockBelow(pos)) {
            pos = this.scanTree(pos.below());
        }
        return pos;
    }

    boolean hasBlockAbove(BlockPos pos) {
        return this.isLog(pos.above()) && this.notVisited(pos.above());
    }

    boolean hasBlockBelow(BlockPos pos) {
        return this.isLog(pos.below()) && this.notVisited(pos.below());
    }

    boolean hasNeighbour(BlockPos pos) {
        return !pos.equals((Object)this.getFirstNeighbour(pos));
    }

    BlockPos getFirstNeighbour(BlockPos pos) {
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                BlockPos block = pos.offset(x, 0, z);
                if (!this.isLog(block) || !this.notVisited(block)) continue;
                return block;
            }
        }
        return pos;
    }

    boolean hasDiagonalNeighbour(BlockPos pos) {
        return !pos.equals((Object)this.getFirstDiagonalNeighbour(pos));
    }

    BlockPos getFirstDiagonalNeighbour(BlockPos pos) {
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                BlockPos block = pos.offset(x, 1, z);
                if (!this.isLog(block) || !this.notVisited(block)) continue;
                return block;
            }
        }
        return pos;
    }

    List<BlockPos> getAllNeighbours(BlockPos pos) {
        ArrayList<BlockPos> neighbours = new ArrayList<BlockPos>();
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                BlockPos block = pos.offset(x, 0, z);
                if (!this.isLog(block)) continue;
                neighbours.add(block);
            }
        }
        return neighbours;
    }

    boolean notVisited(BlockPos pos) {
        return !this.scanned.contains(pos);
    }

    boolean isLog(BlockPos pos) {
        return this.level.getBlockState(pos).is(BlockTags.LOGS);
    }
}

