/*
 * Decompiled with CFR 0.152.
 */
package net.xstopho.resourcelibrary.registration;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.xstopho.resourcelibrary.registration.RegistryObject;
import net.xstopho.resourcelibrary.registration.RegistryProvider;

public class FabricRegistryFactory
implements RegistryProvider.Factory {
    @Override
    public <T> RegistryProvider<T> create(class_5321<? extends class_2378<T>> resourceKey, String modId) {
        return new Provider(resourceKey, modId);
    }

    @Override
    public <T> RegistryProvider<T> create(class_2378<T> registry, String modId) {
        return new Provider<T>(registry, modId);
    }

    private static class Provider<T>
    implements RegistryProvider<T> {
        private final String modId;
        private final class_2378<T> registry;
        private final Set<RegistryObject<T>> entries = new LinkedHashSet<RegistryObject<T>>();
        private final Set<RegistryObject<T>> entriesView = Collections.unmodifiableSet(this.entries);

        private Provider(class_5321<? extends class_2378<T>> key, String modId) {
            this.modId = modId;
            class_2378 reg = (class_2378)class_7923.field_41167.method_10223(key.method_29177());
            if (reg == null) {
                throw new RuntimeException("Registry with name " + String.valueOf(key.method_29177()) + " was not found!");
            }
            this.registry = reg;
        }

        private Provider(class_2378<T> registry, String modId) {
            this.registry = registry;
            this.modId = modId;
        }

        @Override
        public <I extends T> RegistryObject<I> register(String name, Supplier<? extends I> supplier) {
            final class_2960 resourceLocation = class_2960.method_60655((String)this.modId, (String)name);
            final Object object = class_2378.method_10230(this.registry, (class_2960)resourceLocation, supplier.get());
            RegistryObject registryObject = new RegistryObject<I>(){
                final class_5321<I> key;
                {
                    this.key = class_5321.method_29179((class_5321)registry.method_30517(), (class_2960)resourceLocation);
                }

                @Override
                public class_5321<I> getResourceKey() {
                    return this.key;
                }

                @Override
                public class_2960 getId() {
                    return resourceLocation;
                }

                @Override
                public I get() {
                    return object;
                }

                @Override
                public class_6880<I> asHolder() {
                    return registry.method_40290(this.key);
                }
            };
            this.entries.add(registryObject);
            return registryObject;
        }

        @Override
        public Collection<RegistryObject<T>> getEntries() {
            return this.entriesView;
        }

        @Override
        public String getModId() {
            return this.modId;
        }
    }
}

