/*
 * Decompiled with CFR 0.152.
 */
package net.xstopho.resourcelibrary.registration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.javafmlmod.FMLModContainer;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.xstopho.resourcelibrary.registration.RegistryObject;
import net.xstopho.resourcelibrary.registration.RegistryProvider;

public class NeoForgeRegistryFactory
implements RegistryProvider.Factory {
    @Override
    public <T> RegistryProvider<T> create(String modId, Registry<T> registry) {
        Optional optionalModContainer = ModList.get().getModContainerById(modId);
        if (optionalModContainer.isEmpty()) {
            throw new NullPointerException("Cannot find ModContainer for id: " + modId);
        }
        ModContainer modContainer = (ModContainer)optionalModContainer.get();
        if (modContainer instanceof FMLModContainer) {
            FMLModContainer fmlModContainer = (FMLModContainer)modContainer;
            DeferredRegister register = DeferredRegister.create((ResourceKey)registry.key(), (String)modId);
            register.register(Objects.requireNonNull(fmlModContainer.getEventBus()));
            return new Provider(modId, register);
        }
        throw new ClassCastException("The Container of the Mod " + modId + " is not a NeoForge one!");
    }

    private static class Provider<T>
    implements RegistryProvider<T> {
        private final String modId;
        private final DeferredRegister<T> registry;
        private final Collection<RegistryObject<T>> entries = new ArrayList<RegistryObject<T>>();

        public Provider(String modId, DeferredRegister<T> registry) {
            this.registry = registry;
            this.modId = modId;
        }

        @Override
        public <U extends T> RegistryObject<U> register(String objectId, Supplier<? extends U> objectSupplier) {
            final DeferredHolder object = this.registry.register(objectId, objectSupplier);
            RegistryObject registryObject = new RegistryObject<U>(this){

                @Override
                public ResourceKey<U> getResourceKey() {
                    return object.getKey();
                }

                @Override
                public ResourceLocation getId() {
                    return object.getId();
                }

                @Override
                public U get() {
                    return object.get();
                }
            };
            this.entries.add(registryObject);
            return registryObject;
        }

        @Override
        public Collection<RegistryObject<T>> getEntries() {
            return this.entries;
        }

        @Override
        public String getModId() {
            return this.modId;
        }
    }
}

