/*
 * Decompiled with CFR 0.152.
 */
package net.xstopho.resourcelibrary.util;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.LinkedList;
import net.minecraft.client.Minecraft;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.metadata.MetadataSectionType;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.resources.IoSupplier;
import net.xstopho.resourcelibrary.LibConstants;

public class ResourcePackUtils {
    private static final Minecraft client = Minecraft.getInstance();

    public static <T> LinkedList<T> readAllMetaData(MetadataSectionType<T> metadataSectionType) {
        LinkedList<Object> allMetaData = new LinkedList<Object>();
        for (Pack pack : client.getResourcePackRepository().getSelectedPacks()) {
            try {
                PackResources resources = pack.open();
                try {
                    Object metadataSection = resources.getMetadataSection(metadataSectionType);
                    if (metadataSection == null) continue;
                    allMetaData.add(metadataSection);
                }
                finally {
                    if (resources == null) continue;
                    resources.close();
                }
            }
            catch (IOException e) {
                LibConstants.LOG.error("Error reading pack.mcmeta", (Throwable)e);
            }
        }
        return allMetaData;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T readMetaData(MetadataSectionType<T> metadataSectionType) {
        Iterator iterator = client.getResourcePackRepository().getSelectedPacks().iterator();
        while (iterator.hasNext()) {
            Pack pack = (Pack)iterator.next();
            try {
                PackResources resources = pack.open();
                try {
                    Object metadataSection = resources.getMetadataSection(metadataSectionType);
                    if (metadataSection == null) continue;
                    Object object = metadataSection;
                    return (T)object;
                }
                finally {
                    if (resources == null) continue;
                    resources.close();
                }
            }
            catch (IOException e) {
                LibConstants.LOG.error("Error reading pack.mcmeta", (Throwable)e);
            }
        }
        return null;
    }

    public static LinkedList<JsonObject> readAllMetaData(String object) {
        LinkedList<JsonObject> allMetaData = new LinkedList<JsonObject>();
        for (Pack pack : client.getResourcePackRepository().getSelectedPacks()) {
            try {
                PackResources resources = pack.open();
                try {
                    IoSupplier ioSup = resources.getRootResource(new String[]{"pack.mcmeta"});
                    if (ioSup == null) continue;
                    InputStream metaStream = (InputStream)ioSup.get();
                    try {
                        String json = new String(metaStream.readAllBytes(), StandardCharsets.UTF_8);
                        JsonObject meta = JsonParser.parseString((String)json).getAsJsonObject();
                        if (!meta.has(object) || !meta.get(object).isJsonObject()) continue;
                        allMetaData.add(meta.getAsJsonObject(object));
                    }
                    finally {
                        if (metaStream == null) continue;
                        metaStream.close();
                    }
                }
                finally {
                    if (resources == null) continue;
                    resources.close();
                }
            }
            catch (IOException e) {
                LibConstants.LOG.error("Error reading pack.mcmeta", (Throwable)e);
            }
        }
        return allMetaData;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static JsonObject readMetaData(String object) {
        Iterator iterator = client.getResourcePackRepository().getSelectedPacks().iterator();
        while (iterator.hasNext()) {
            Pack pack = (Pack)iterator.next();
            try {
                PackResources resources = pack.open();
                try {
                    IoSupplier ioSup = resources.getRootResource(new String[]{"pack.mcmeta"});
                    if (ioSup == null) continue;
                    InputStream metaStream = (InputStream)ioSup.get();
                    try {
                        String json = new String(metaStream.readAllBytes(), StandardCharsets.UTF_8);
                        JsonObject meta = JsonParser.parseString((String)json).getAsJsonObject();
                        if (!meta.has(object) || !meta.get(object).isJsonObject()) continue;
                        JsonObject jsonObject = meta.getAsJsonObject(object);
                        return jsonObject;
                    }
                    finally {
                        if (metaStream == null) continue;
                        metaStream.close();
                    }
                }
                finally {
                    if (resources == null) continue;
                    resources.close();
                }
            }
            catch (IOException e) {
                LibConstants.LOG.error("Error reading pack.mcmeta", (Throwable)e);
            }
        }
        return null;
    }
}

