/*
 * Decompiled with CFR 0.152.
 */
package org.forsteri.ratatouille.compat.jei.category.animations;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllPartialModels;
import com.simibubi.create.compat.jei.category.animations.AnimatedKinetics;
import net.createmod.catnip.animation.AnimationTickHolder;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.forsteri.ratatouille.content.squeeze_basin.SqueezeBasinBlock;
import org.forsteri.ratatouille.entry.CRBlocks;
import org.forsteri.ratatouille.entry.CRPartialModels;

public class AnimatedSqueeze
extends AnimatedKinetics {
    private boolean useCasing = false;

    public void setUseCasing(boolean useCasing) {
        this.useCasing = useCasing;
    }

    public void draw(GuiGraphics graphics, int xOffset, int yOffset) {
        PoseStack matrixStack = graphics.pose();
        matrixStack.pushPose();
        matrixStack.translate((float)xOffset, (float)yOffset, 200.0f);
        matrixStack.mulPose(Axis.XP.rotationDegrees(-15.5f));
        matrixStack.mulPose(Axis.YP.rotationDegrees(22.5f));
        int scale = 23;
        this.blockElement(this.shaft(Direction.Axis.Z)).rotateBlock(0.0, 0.0, (double)AnimatedSqueeze.getCurrentAngle()).scale((double)scale).render(graphics);
        this.blockElement(AllBlocks.MECHANICAL_PRESS.getDefaultState()).scale((double)scale).render(graphics);
        this.blockElement(AllPartialModels.MECHANICAL_PRESS_HEAD).atLocal(0.0, (double)(-this.getAnimatedHeadOffset()), 0.0).scale((double)scale).render(graphics);
        this.blockElement((BlockState)CRBlocks.SQUEEZE_BASIN.getDefaultState().setValue((Property)SqueezeBasinBlock.CASING, (Comparable)Boolean.valueOf(this.useCasing))).atLocal(0.0, 1.65, 0.0).scale((double)scale).render(graphics);
        this.blockElement(CRPartialModels.SQUEEZE_BASIN_COVER).atLocal(0.0, (double)(-this.getAnimatedCoverOffset()), 0.0).scale((double)scale).render(graphics);
        matrixStack.popPose();
    }

    private float getAnimatedHeadOffset() {
        float cycle = (AnimationTickHolder.getRenderTime() - (float)(this.offset * 8)) % 30.0f;
        if (cycle < 10.0f) {
            float progress = cycle / 10.0f;
            return -(progress * progress * progress);
        }
        if (cycle < 15.0f) {
            return -1.0f;
        }
        if (cycle < 20.0f) {
            return -1.0f + (1.0f - (20.0f - cycle) / 5.0f);
        }
        return 0.0f;
    }

    private float getAnimatedCoverOffset() {
        float offset = this.getAnimatedHeadOffset() - 1.0f;
        return Math.min(-1.65f, offset);
    }
}

