/*
 * Decompiled with CFR 0.152.
 */
package org.forsteri.ratatouille.content.compost_tower;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.common.util.INBTSerializable;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import org.forsteri.ratatouille.entry.CRFluids;
import org.jetbrains.annotations.NotNull;

public class CompostFluidTank
implements IFluidHandler,
INBTSerializable<CompoundTag> {
    protected final BiMap<Fluid, Integer> fluidIds;
    protected final HashMap<Fluid, Integer> tanks;
    protected final Consumer<HashMap<Fluid, Integer>> updateCallback;
    protected int capacity;
    protected int index;

    public CompostFluidTank(BiMap<Fluid, Integer> fluidIds, HashMap<Fluid, Integer> tanks, Consumer<HashMap<Fluid, Integer>> updateCallback, int index, int capacity) {
        this.fluidIds = fluidIds;
        this.tanks = tanks;
        this.updateCallback = updateCallback;
        this.index = index;
        this.capacity = capacity;
    }

    public CompostFluidTank(int capacity, Consumer<HashMap<Fluid, Integer>> updateCallback) {
        this.capacity = capacity;
        this.updateCallback = updateCallback;
        this.tanks = new HashMap();
        this.fluidIds = HashBiMap.create();
        this.index = 0;
    }

    public int getTanks() {
        return this.index + 1;
    }

    @NotNull
    public FluidStack getFluidInTank(int tank) {
        Fluid fluid = (Fluid)this.fluidIds.inverse().get((Object)tank);
        if (fluid == null) {
            return FluidStack.EMPTY;
        }
        return new FluidStack(fluid, this.tanks.get(fluid).intValue());
    }

    public int getTankCapacity(int tank) {
        Fluid fluid = (Fluid)this.fluidIds.inverse().get((Object)tank);
        if (fluid == null) {
            return this.getRemainingAmount();
        }
        return this.getRemainingAmount() + this.tanks.get(fluid);
    }

    public int getRemainingAmount() {
        return this.capacity - this.getFilledAmount();
    }

    public int getFilledAmount() {
        return this.tanks.values().stream().mapToInt(Integer::intValue).sum();
    }

    public boolean isFluidValid(int tank, @NotNull FluidStack stack) {
        Fluid fluid = (Fluid)this.fluidIds.inverse().get((Object)tank);
        if (fluid == null) {
            return true;
        }
        return stack.getFluid().isSame(fluid);
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        if (resource.isEmpty()) {
            return 0;
        }
        Fluid resourceFluid = resource.getFluid();
        int resourceAmount = resource.getAmount();
        Integer existingAmount = this.tanks.getOrDefault(resourceFluid, 0);
        int filled = Math.min(this.getRemainingAmount(), resourceAmount);
        if (action.execute()) {
            this.tanks.put(resourceFluid, existingAmount + filled);
            this.onContentsChanged();
            if (!this.fluidIds.containsKey((Object)resourceFluid)) {
                this.fluidIds.put((Object)resourceFluid, (Object)this.index++);
            }
        }
        return filled;
    }

    @NotNull
    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        if (resource.isEmpty()) {
            return FluidStack.EMPTY;
        }
        Fluid resourceFluid = resource.getFluid();
        int resourceAmount = resource.getAmount();
        Integer existingAmount = this.tanks.getOrDefault(resourceFluid, 0);
        int drained = Math.min(existingAmount, resourceAmount);
        if (action.execute()) {
            this.tanks.put(resourceFluid, existingAmount - drained);
            this.onContentsChanged();
        }
        return new FluidStack(resourceFluid, drained);
    }

    public void onContentsChanged() {
        this.updateCallback.accept(this.tanks);
    }

    @NotNull
    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        if (maxDrain <= 0 || this.tanks.isEmpty()) {
            return FluidStack.EMPTY;
        }
        Fluid maxFluid = this.tanks.entrySet().stream().filter(entry -> (Integer)entry.getValue() > 0).max(Comparator.comparingInt(Map.Entry::getValue)).map(Map.Entry::getKey).orElse(null);
        if (maxFluid == null) {
            return FluidStack.EMPTY;
        }
        int available = this.tanks.get(maxFluid);
        int drained = Math.min(available, maxDrain);
        if (action.execute()) {
            this.tanks.put(maxFluid, available - drained);
            this.onContentsChanged();
        }
        return new FluidStack(maxFluid, drained);
    }

    @ParametersAreNonnullByDefault
    public CompoundTag serializeNBT(HolderLookup.Provider provider) {
        CompoundTag tag = new CompoundTag();
        tag.putInt("Capacity", this.capacity);
        tag.putInt("Index", this.index);
        ListTag tankList = new ListTag();
        for (Fluid fluid : this.tanks.keySet()) {
            CompoundTag fluidTag = new CompoundTag();
            FluidStack fluidStack = new FluidStack(fluid, this.tanks.get(fluid).intValue());
            if (fluidStack.isEmpty()) continue;
            fluidTag.put("FluidStack", fluidStack.save(provider));
            fluidTag.putInt("Id", ((Integer)this.fluidIds.get((Object)fluid)).intValue());
            tankList.add((Object)fluidTag);
        }
        tag.put("Tanks", (Tag)tankList);
        return tag;
    }

    @ParametersAreNonnullByDefault
    public void deserializeNBT(HolderLookup.Provider provider, CompoundTag compoundTag) {
        this.capacity = compoundTag.getInt("Capacity");
        this.index = compoundTag.getInt("Index");
        this.tanks.clear();
        this.fluidIds.clear();
        ListTag tankList = compoundTag.getList("Tanks", 10);
        for (int i = 0; i < tankList.size(); ++i) {
            CompoundTag fluidTag = tankList.getCompound(i);
            FluidStack stack = FluidStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)fluidTag.getCompound("FluidStack"));
            if (stack.isEmpty()) continue;
            int id = fluidTag.getInt("Id");
            Fluid fluid = stack.getFluid();
            this.tanks.put(fluid, stack.getAmount());
            this.fluidIds.put((Object)fluid, (Object)id);
        }
    }

    public int getCapacity() {
        return this.capacity;
    }

    public void setCapacity(int capacity) {
        this.capacity = capacity;
    }

    public Fluid[] getSortedFluids() {
        return (Fluid[])this.tanks.keySet().stream().sorted(Comparator.comparingInt(fluid -> fluid.getFluidType().getDensity()).reversed()).toArray(Fluid[]::new);
    }

    public void clearOverflow() {
        int overflow = -this.getRemainingAmount();
        if (overflow <= 0) {
            return;
        }
        for (Fluid fluid : this.tanks.keySet()) {
            int amount = this.tanks.getOrDefault(fluid, 0);
            if (amount <= 0) continue;
            int toDrain = Math.min(overflow, amount);
            this.tanks.put(fluid, amount - toDrain);
            if ((overflow -= toDrain) > 0) continue;
            break;
        }
    }

    public void fillFrom(CompostFluidTank otherTank) {
        for (FluidStack stack : otherTank.getFluidStacks()) {
            this.fill(stack, IFluidHandler.FluidAction.EXECUTE);
        }
    }

    public FluidStack[] getFluidStacks() {
        return (FluidStack[])this.tanks.entrySet().stream().map(entry -> new FluidStack((Fluid)entry.getKey(), ((Integer)entry.getValue()).intValue())).toArray(FluidStack[]::new);
    }

    public void clear() {
        this.tanks.replaceAll((f, v) -> 0);
        this.onContentsChanged();
    }

    public Fluid getFluidAtBlockHeight(int blockHeight, int towerHeight) {
        double height;
        if (this.tanks.isEmpty() || towerHeight <= 0) {
            return FluidStack.EMPTY.getFluid();
        }
        List<Fluid> liquids = this.tanks.keySet().stream().filter(f -> !f.getFluidType().isLighterThanAir()).sorted(Comparator.comparingInt(f -> f.getFluidType().getDensity()).reversed()).toList();
        List<Fluid> gases = this.tanks.keySet().stream().filter(f -> f.getFluidType().isLighterThanAir()).sorted(Comparator.comparingInt(f -> f.getFluidType().getDensity())).toList();
        float accumulatedHeight = 0.0f;
        for (Fluid fluid : liquids) {
            height = Math.floor((accumulatedHeight += this.getFilledPercentage(fluid)) * (float)towerHeight);
            if (this.tanks.getOrDefault(fluid, 0) == 0 || this.isValidInputFluid(fluid) || !((double)blockHeight <= height)) continue;
            return fluid;
        }
        accumulatedHeight = 0.0f;
        for (Fluid fluid : gases) {
            height = Math.ceil((accumulatedHeight += this.getFilledPercentage(fluid)) * (float)towerHeight);
            if (this.tanks.getOrDefault(fluid, 0) == 0 || this.isValidInputFluid(fluid) || !((double)blockHeight >= (double)towerHeight - height)) continue;
            return fluid;
        }
        return FluidStack.EMPTY.getFluid();
    }

    public float getFilledPercentage(Fluid fluid) {
        float existingAmount = this.tanks.getOrDefault(fluid, 0).intValue();
        return existingAmount / (float)this.capacity;
    }

    private boolean isValidInputFluid(Fluid resource) {
        return resource.isSame((Fluid)CRFluids.COMPOST_FLUID.get());
    }
}

