/*
 * Decompiled with CFR 0.152.
 */
package org.forsteri.ratatouille.content.demolder;

import com.mojang.math.Axis;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.ShaftVisual;
import com.simibubi.create.content.kinetics.press.PressingBehaviour;
import dev.engine_room.flywheel.api.visual.DynamicVisual;
import dev.engine_room.flywheel.api.visualization.VisualizationContext;
import dev.engine_room.flywheel.lib.instance.FlatLit;
import dev.engine_room.flywheel.lib.instance.InstanceTypes;
import dev.engine_room.flywheel.lib.instance.OrientedInstance;
import dev.engine_room.flywheel.lib.model.Models;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import dev.engine_room.flywheel.lib.visual.SimpleDynamicVisual;
import net.createmod.catnip.math.AngleHelper;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import org.forsteri.ratatouille.content.demolder.MechanicalDemolderBlock;
import org.forsteri.ratatouille.content.demolder.MechanicalDemolderBlockEntity;
import org.forsteri.ratatouille.entry.CRPartialModels;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public class DemolderVisual
extends ShaftVisual<MechanicalDemolderBlockEntity>
implements SimpleDynamicVisual {
    private final OrientedInstance head = (OrientedInstance)this.instancerProvider().instancer(InstanceTypes.ORIENTED, Models.partial((PartialModel)CRPartialModels.MECHANICAL_DEMOLDER_HEAD)).createInstance();

    public DemolderVisual(VisualizationContext context, MechanicalDemolderBlockEntity blockEntity, float partialTick) {
        super(context, (KineticBlockEntity)blockEntity, partialTick);
        Quaternionf q = Axis.YP.rotationDegrees(AngleHelper.horizontalAngle((Direction)((Direction)this.blockState.getValue(MechanicalDemolderBlock.HORIZONTAL_FACING))));
        this.head.rotation((Quaternionfc)q);
        this.transformModels(partialTick);
    }

    public void beginFrame(DynamicVisual.Context ctx) {
        this.transformModels(ctx.partialTick());
    }

    private void transformModels(float pt) {
        float renderedHeadOffset = this.getRenderedHeadOffset(pt);
        this.head.position((Vec3i)this.getVisualPosition()).translatePosition(0.0f, -renderedHeadOffset, 0.0f).setChanged();
    }

    private float getRenderedHeadOffset(float pt) {
        PressingBehaviour pressingBehaviour = ((MechanicalDemolderBlockEntity)this.blockEntity).getPressingBehaviour();
        return pressingBehaviour.getRenderedHeadOffset(pt) * pressingBehaviour.mode.headOffset;
    }

    public void updateLight(float partialTick) {
        super.updateLight(partialTick);
        this.relight(new FlatLit[]{this.head});
    }

    protected void _delete() {
        super._delete();
        this.head.delete();
    }
}

