/*
 * Decompiled with CFR 0.152.
 */
package org.forsteri.ratatouille.content.demolder;

import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.belt.transport.TransportedItemStack;
import com.simibubi.create.content.kinetics.press.PressingBehaviour;
import com.simibubi.create.content.processing.sequenced.SequencedAssemblyRecipe;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.item.ItemHelper;
import com.simibubi.create.foundation.recipe.RecipeApplier;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.items.wrapper.CombinedInvWrapper;
import org.forsteri.ratatouille.content.demolder.DemoldingRecipe;
import org.forsteri.ratatouille.entry.CRBlockEntityTypes;
import org.forsteri.ratatouille.entry.CRRecipeTypes;
import org.forsteri.ratatouille.entry.CRTags;

public class MechanicalDemolderBlockEntity
extends KineticBlockEntity
implements PressingBehaviour.PressingBehaviourSpecifics {
    public ItemStackHandler outputInv = new ItemStackHandler(1);
    public IItemHandler capability = new DemolderInventoryHandler(this);
    public PressingBehaviour demoldingBehaviour;

    public MechanicalDemolderBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)CRBlockEntityTypes.MECHANICAL_DEMOLDER_ENTITY.get(), (be, context) -> be.capability);
    }

    protected AABB createRenderBoundingBox() {
        return new AABB(this.worldPosition).expandTowards(0.0, -1.5, 0.0).expandTowards(0.0, 1.0, 0.0);
    }

    public PressingBehaviour getPressingBehaviour() {
        return this.demoldingBehaviour;
    }

    public void invalidate() {
        super.invalidate();
        this.invalidateCapabilities();
    }

    public void destroy() {
        super.destroy();
        ItemHelper.dropContents((Level)this.level, (BlockPos)this.worldPosition, (IItemHandler)this.outputInv);
    }

    public boolean tryProcessInBasin(boolean simulate) {
        return false;
    }

    public boolean tryProcessOnBelt(TransportedItemStack input, List<ItemStack> outputList, boolean simulate) {
        for (int i = 0; i < this.outputInv.getSlots(); ++i) {
            if (this.outputInv.getStackInSlot(i).getCount() != this.outputInv.getSlotLimit(i)) continue;
            return false;
        }
        Optional<RecipeHolder<DemoldingRecipe>> recipe = this.getRecipe(input.stack);
        if (recipe.isEmpty()) {
            return false;
        }
        if (simulate) {
            return true;
        }
        this.demoldingBehaviour.particleItems.add(input.stack);
        List outputs = RecipeApplier.applyRecipeOn((Level)this.level, (ItemStack)(this.canProcessInBulk() ? input.stack : new ItemStack((ItemLike)input.stack.getItem(), 1)), recipe.get());
        for (ItemStack itemStack : outputs) {
            if (!itemStack.is(CRTags.MOLD)) {
                outputList.add(itemStack);
                continue;
            }
            if (this.outputInv.insertItem(0, itemStack.copy(), true).isEmpty()) {
                this.outputInv.insertItem(0, itemStack.copy(), false);
                return true;
            }
            return false;
        }
        return true;
    }

    public Optional<RecipeHolder<DemoldingRecipe>> getRecipe(ItemStack item) {
        if (this.level == null) {
            return Optional.empty();
        }
        Optional assemblyRecipe = SequencedAssemblyRecipe.getRecipe((Level)this.level, (ItemStack)item, CRRecipeTypes.DEMOLDING.getType(), DemoldingRecipe.class);
        if (assemblyRecipe.isPresent()) {
            return assemblyRecipe;
        }
        return CRRecipeTypes.DEMOLDING.find(new SingleRecipeInput(item), this.level);
    }

    public boolean tryProcessInWorld(ItemEntity itemEntity, boolean simulate) {
        return false;
    }

    public boolean canProcessInBulk() {
        return false;
    }

    public void onPressingCompleted() {
    }

    public int getParticleAmount() {
        return 15;
    }

    public float getKineticSpeed() {
        return this.getSpeed();
    }

    public float calculateStressApplied() {
        return 8.0f;
    }

    protected void write(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        compound.put("OutputInventory", (Tag)this.outputInv.serializeNBT(registries));
        super.write(compound, registries, clientPacket);
    }

    protected void read(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        this.outputInv.deserializeNBT(registries, compound.getCompound("OutputInventory"));
        super.read(compound, registries, clientPacket);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        this.demoldingBehaviour = new PressingBehaviour((SmartBlockEntity)this);
        behaviours.add((BlockEntityBehaviour)this.demoldingBehaviour);
    }

    private class DemolderInventoryHandler
    extends CombinedInvWrapper {
        public DemolderInventoryHandler(MechanicalDemolderBlockEntity mechanicalDemolderBlockEntity) {
            super(new IItemHandlerModifiable[]{mechanicalDemolderBlockEntity.outputInv});
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            return stack;
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return super.extractItem(slot, amount, simulate);
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            return false;
        }
    }
}

