/*
 * Decompiled with CFR 0.152.
 */
package org.forsteri.ratatouille.content.frozen_block;

import com.mojang.serialization.MapCodec;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.Vec3;
import org.forsteri.ratatouille.content.frozen_block.FrozenBlockEntity;
import org.forsteri.ratatouille.entry.CRBlockEntityTypes;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FrozenBlock
extends BaseEntityBlock {
    public static final MapCodec<FrozenBlock> CODEC = FrozenBlock.simpleCodec(FrozenBlock::new);

    public FrozenBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    @NotNull
    public RenderShape getRenderShape(@NotNull BlockState pState) {
        return RenderShape.MODEL;
    }

    public void animateTick(@NotNull BlockState pState, @NotNull Level pLevel, @NotNull BlockPos pPos, RandomSource pRand) {
        if (pRand.nextInt(5) != 0) {
            return;
        }
        Vec3 vec3 = VecHelper.clampComponentWise((Vec3)VecHelper.offsetRandomly((Vec3)Vec3.ZERO, (RandomSource)pRand, (float)0.75f), (float)0.55f).add(VecHelper.getCenterOf((Vec3i)pPos));
        pLevel.addParticle((ParticleOptions)ParticleTypes.END_ROD, vec3.x, vec3.y, vec3.z, pRand.nextGaussian() * 0.005, pRand.nextGaussian() * 0.005, pRand.nextGaussian() * 0.005);
    }

    public void randomTick(@NotNull BlockState pState, @NotNull ServerLevel pLevel, BlockPos pPos, @NotNull RandomSource pRandom) {
        for (BlockPos blockpos : BlockPos.betweenClosed((BlockPos)pPos.offset(-4, -4, -4), (BlockPos)pPos.offset(4, 4, 4))) {
            if (!pLevel.getBlockState(blockpos).is(Blocks.TORCH)) continue;
            return;
        }
        for (BlockPos blockpos : BlockPos.betweenClosed((BlockPos)pPos.offset(-4, -4, -4), (BlockPos)pPos.offset(4, 4, 4))) {
            FluidState fluidState = pLevel.getFluidState(blockpos);
            if (!fluidState.is((Fluid)Fluids.WATER) || !fluidState.isSource()) continue;
            pLevel.setBlockAndUpdate(blockpos, Blocks.ICE.defaultBlockState());
            return;
        }
    }

    @Nullable
    public BlockEntity newBlockEntity(@NotNull BlockPos pPos, @NotNull BlockState pState) {
        return new FrozenBlockEntity((BlockEntityType)CRBlockEntityTypes.FROZEN_BLOCK_ENTITY.get(), pPos, pState);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(@NotNull Level pLevel, @NotNull BlockState pState, @NotNull BlockEntityType<T> pBlockEntityType) {
        return FrozenBlock.createTickerHelper(pBlockEntityType, (BlockEntityType)((BlockEntityType)CRBlockEntityTypes.FROZEN_BLOCK_ENTITY.get()), FrozenBlockEntity::tick);
    }
}

