/*
 * Decompiled with CFR 0.152.
 */
package org.forsteri.ratatouille.content.frozen_block;

import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import org.forsteri.ratatouille.content.frozen_block.FreezingRecipe;
import org.forsteri.ratatouille.entry.CRDataComponents;
import org.forsteri.ratatouille.entry.CRRecipeTypes;

public class FrozenBlockEntity
extends BlockEntity {
    public static int MAX_CHILLNESS = 50;

    public FrozenBlockEntity(BlockEntityType<?> pType, BlockPos pPos, BlockState pBlockState) {
        super(pType, pPos, pBlockState);
    }

    public static void tick(Level pLevel, BlockPos pPos, BlockState pState, FrozenBlockEntity pBlockEntity) {
        if (pLevel == null || pLevel.isClientSide) {
            return;
        }
        double x = pPos.getX();
        double y = pPos.getY() + 1;
        double z = pPos.getZ();
        AABB searchBox = new AABB(x, y, z, x + 1.0, y + 0.25, z + 1.0);
        List itemEntities = pLevel.getEntitiesOfClass(ItemEntity.class, searchBox);
        for (ItemEntity itemEntity : itemEntities) {
            ItemStack itemStack = itemEntity.getItem();
            Optional recipe = CRRecipeTypes.FREEZING.find(new SingleRecipeInput(itemStack), pLevel);
            if (recipe.isEmpty()) continue;
            Integer chillness = (Integer)itemStack.getOrDefault(CRDataComponents.COLLECTING_CHILLNESS, (Object)0);
            if (chillness >= MAX_CHILLNESS) {
                itemStack.remove(CRDataComponents.COLLECTING_CHILLNESS);
                ItemStack newStack = ((FreezingRecipe)recipe.get().value()).getResultItem((HolderLookup.Provider)pLevel.registryAccess());
                newStack.setCount(itemStack.getCount());
                itemEntity.setItem(newStack);
                continue;
            }
            itemStack.set(CRDataComponents.COLLECTING_CHILLNESS, (Object)(chillness + 1));
        }
    }
}

