/*
 * Decompiled with CFR 0.152.
 */
package org.forsteri.ratatouille.content.irrigation_tower;

import com.mojang.serialization.MapCodec;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.content.fluids.transfer.GenericItemEmptying;
import com.simibubi.create.content.fluids.transfer.GenericItemFilling;
import com.simibubi.create.foundation.block.IBE;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.fluid.FluidHelper;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.BaseFlowingFluid;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import org.forsteri.ratatouille.content.irrigation_tower.IrrigationTowerBlockEntity;
import org.forsteri.ratatouille.entry.CRBlockEntityTypes;
import org.forsteri.ratatouille.entry.CRFluids;
import vectorwing.farmersdelight.common.registry.ModBlocks;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class IrrigationTowerBlock
extends HorizontalDirectionalBlock
implements IWrenchable,
IBE<IrrigationTowerBlockEntity> {
    public static final MapCodec<IrrigationTowerBlock> CODEC = IrrigationTowerBlock.simpleCodec(IrrigationTowerBlock::new);

    public IrrigationTowerBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties.randomTicks());
    }

    protected MapCodec<? extends HorizontalDirectionalBlock> codec() {
        return CODEC;
    }

    protected ItemInteractionResult useItemOn(ItemStack heldItem, BlockState state, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult hitResult) {
        return this.onBlockEntityUseItemOn((BlockGetter)pLevel, pPos, be -> {
            if (heldItem.isEmpty()) return ItemInteractionResult.FAIL;
            if (FluidHelper.tryEmptyItemIntoBE((Level)pLevel, (Player)pPlayer, (InteractionHand)pHand, (ItemStack)heldItem, (SmartBlockEntity)be)) {
                return ItemInteractionResult.SUCCESS;
            }
            if (FluidHelper.tryFillItemFromBE((Level)pLevel, (Player)pPlayer, (InteractionHand)pHand, (ItemStack)heldItem, (SmartBlockEntity)be)) {
                return ItemInteractionResult.SUCCESS;
            }
            if (GenericItemEmptying.canItemBeEmptied((Level)pLevel, (ItemStack)heldItem) || GenericItemFilling.canItemBeFilled((Level)pLevel, (ItemStack)heldItem)) {
                return ItemInteractionResult.SUCCESS;
            }
            if (!heldItem.getItem().equals(Items.SPONGE)) return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
            IFluidHandler fluidHandler = (IFluidHandler)pLevel.getCapability(Capabilities.FluidHandler.BLOCK, pPos, null);
            if (fluidHandler == null) return ItemInteractionResult.SUCCESS;
            FluidStack drained = fluidHandler.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.EXECUTE);
            if (drained.isEmpty()) return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
            return ItemInteractionResult.SUCCESS;
        });
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return Shapes.create((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)1.5, (double)1.0);
    }

    public void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (!(blockEntity instanceof IrrigationTowerBlockEntity)) {
            return;
        }
        IrrigationTowerBlockEntity tower = (IrrigationTowerBlockEntity)blockEntity;
        FluidStack simulate = tower.getTankInventory().drain(new FluidStack(((BaseFlowingFluid.Flowing)CRFluids.COMPOST_TEA.get()).getSource(), 100), IFluidHandler.FluidAction.SIMULATE);
        if (simulate.isEmpty() || simulate.getAmount() < 100) {
            return;
        }
        BlockPos center = pos.below();
        for (int dx = -8; dx <= 8; ++dx) {
            for (int dy = -1; dy <= 1; ++dy) {
                for (int dz = -8; dz <= 8; ++dz) {
                    BlockPos target = center.offset(dx, dy, dz);
                    BlockState targetState = level.getBlockState(target);
                    if (!targetState.is(Blocks.FARMLAND)) continue;
                    BlockState newState = ((Block)ModBlocks.RICH_SOIL_FARMLAND.get()).defaultBlockState();
                    level.setBlockAndUpdate(target, newState);
                    level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, target, GameEvent.Context.of(null, (BlockState)newState));
                    tower.getTankInventory().drain(new FluidStack(((BaseFlowingFluid.Flowing)CRFluids.COMPOST_TEA.get()).getSource(), 100), IFluidHandler.FluidAction.EXECUTE);
                    return;
                }
            }
        }
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Direction preferredFacing = context.getHorizontalDirection().getOpposite();
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)(context.getPlayer() != null && context.getPlayer().isShiftKeyDown() ? preferredFacing : preferredFacing.getOpposite()));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.createBlockStateDefinition(pBuilder.add(new Property[]{FACING}));
    }

    public Class<IrrigationTowerBlockEntity> getBlockEntityClass() {
        return IrrigationTowerBlockEntity.class;
    }

    public BlockEntityType<? extends IrrigationTowerBlockEntity> getBlockEntityType() {
        return (BlockEntityType)CRBlockEntityTypes.IRRIGATION_TOWER_BLOCK_ENTITY.get();
    }
}

