/*
 * Decompiled with CFR 0.152.
 */
package org.forsteri.ratatouille.content.oven;

import com.simibubi.create.api.connectivity.ConnectivityHandler;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.foundation.block.IBE;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.forsteri.ratatouille.content.oven.OvenBlockEntity;
import org.forsteri.ratatouille.entry.CRBlockEntityTypes;
import org.jetbrains.annotations.NotNull;

public class OvenBlock
extends Block
implements IWrenchable,
IBE<OvenBlockEntity> {
    public static final BooleanProperty IS_2x2 = BooleanProperty.create((String)"is_2x2");

    public OvenBlock(BlockBehaviour.Properties p_i48440_1_) {
        super(p_i48440_1_);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)IS_2x2, (Comparable)Boolean.valueOf(false)));
    }

    public void onPlace(BlockState state, @NotNull Level world, @NotNull BlockPos pos, BlockState oldState, boolean moved) {
        if (oldState.getBlock() == state.getBlock()) {
            return;
        }
        if (moved) {
            return;
        }
        this.withBlockEntityDo((BlockGetter)world, pos, OvenBlockEntity::updateConnectivity);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> p_206840_1_) {
        p_206840_1_.add(new Property[]{IS_2x2});
    }

    public void onRemove(BlockState state, @NotNull Level world, @NotNull BlockPos pos, @NotNull BlockState newState, boolean isMoving) {
        if (state.hasBlockEntity() && (state.getBlock() != newState.getBlock() || !newState.hasBlockEntity())) {
            BlockEntity be = world.getBlockEntity(pos);
            if (!(be instanceof OvenBlockEntity)) {
                return;
            }
            OvenBlockEntity ovenBE = (OvenBlockEntity)be;
            world.removeBlockEntity(pos);
            ConnectivityHandler.splitMulti((BlockEntity)ovenBE);
        }
    }

    public Class<OvenBlockEntity> getBlockEntityClass() {
        return OvenBlockEntity.class;
    }

    public BlockEntityType<? extends OvenBlockEntity> getBlockEntityType() {
        return (BlockEntityType)CRBlockEntityTypes.OVEN_ENTITY.get();
    }

    public void onNeighborChange(BlockState state, LevelReader level, BlockPos pos, BlockPos neighbor) {
        this.withBlockEntityDo((BlockGetter)level, pos, OvenBlockEntity::updateOvenState);
    }

    @NotNull
    public BlockState updateShape(@NotNull BlockState p_60541_, @NotNull Direction p_60542_, @NotNull BlockState p_60543_, @NotNull LevelAccessor p_60544_, @NotNull BlockPos p_60545_, @NotNull BlockPos p_60546_) {
        if (p_60543_.getBlock() != this) {
            this.withBlockEntityDo((BlockGetter)p_60544_, p_60545_, OvenBlockEntity::updateBakeData);
        }
        return super.updateShape(p_60541_, p_60542_, p_60543_, p_60544_, p_60545_, p_60546_);
    }

    public void animateTick(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos blockPos, @NotNull RandomSource random) {
        super.animateTick(state, level, blockPos, random);
        OvenBlockEntity be = (OvenBlockEntity)this.getBlockEntity((BlockGetter)level, blockPos);
        if (be == null) {
            return;
        }
        if ((be = be.getControllerBE()) == null) {
            return;
        }
        if (random.nextInt(5) != 0) {
            return;
        }
        if (be.bakeData.tempLevel <= 0) {
            return;
        }
        if (level.getBlockState(blockPos.above()).getBlock() instanceof OvenBlock) {
            return;
        }
        CampfireBlock.makeParticles((Level)level, (BlockPos)blockPos, (be.bakeData.tempLevel > 4 ? 1 : 0) != 0, (boolean)false);
    }
}

