/*
 * Decompiled with CFR 0.152.
 */
package org.forsteri.ratatouille.content.oven;

import com.simibubi.create.api.connectivity.ConnectivityHandler;
import com.simibubi.create.api.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.foundation.blockEntity.IMultiBlockEntityContainer;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.ParametersAreNonnullByDefault;
import net.createmod.catnip.nbt.NBTHelper;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.item.crafting.SmokingRecipe;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.items.wrapper.CombinedInvWrapper;
import org.forsteri.ratatouille.content.oven.BakeData;
import org.forsteri.ratatouille.content.oven.BakingRecipe;
import org.forsteri.ratatouille.content.oven.OvenBlock;
import org.forsteri.ratatouille.entry.CRBlockEntityTypes;
import org.forsteri.ratatouille.entry.CRRecipeTypes;
import org.jetbrains.annotations.NotNull;

public class OvenBlockEntity
extends SmartBlockEntity
implements IHaveGoggleInformation,
IMultiBlockEntityContainer {
    public CombinedInvWrapper itemCapability;
    public List<List<List<Inventory>>> inventories = null;
    protected BlockPos controller;
    protected BlockPos lastKnownPos;
    protected BakeData bakeData;
    protected Inventory inventory = new Inventory();
    protected int height = 1;
    protected int radius = 1;
    private boolean updateConnectivity = false;

    public OvenBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.bakeData = new BakeData();
    }

    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)CRBlockEntityTypes.OVEN_ENTITY.get(), (be, context) -> {
            be.initCapability();
            if (be.itemCapability == null) {
                return null;
            }
            return be.itemCapability;
        });
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
    }

    public void initialize() {
        super.initialize();
        this.notifyUpdate();
        if (this.level == null) {
            return;
        }
        if (this.level.isClientSide) {
            this.invalidateRenderBoundingBox();
        }
    }

    public void tick() {
        super.tick();
        if (this.isController()) {
            this.bakeData.tick(this);
        }
        if (this.lastKnownPos == null) {
            this.lastKnownPos = this.getBlockPos();
        } else if (!this.lastKnownPos.equals((Object)this.worldPosition)) {
            this.removeController(true);
            this.lastKnownPos = this.worldPosition;
            return;
        }
        if (this.updateConnectivity) {
            this.updateConnectivity();
        }
    }

    public void updateConnectivity() {
        assert (this.level != null);
        this.updateConnectivity = false;
        if (this.level.isClientSide) {
            return;
        }
        if (!this.isController()) {
            return;
        }
        ConnectivityHandler.formMulti((BlockEntity)this);
    }

    private void refreshCapability() {
        this.itemCapability = null;
        this.invalidateCapabilities();
    }

    protected void write(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        if (this.updateConnectivity) {
            compound.putBoolean("Uninitialized", true);
        }
        if (this.lastKnownPos != null) {
            compound.put("LastKnownPos", NbtUtils.writeBlockPos((BlockPos)this.lastKnownPos));
        }
        if (!this.isController()) {
            compound.put("Controller", NbtUtils.writeBlockPos((BlockPos)this.controller));
        }
        if (this.isController()) {
            compound.putInt("Size", this.radius);
            compound.putInt("Height", this.height);
        }
        super.write(compound, registries, clientPacket);
        compound.putString("StorageType", "CombinedInv");
        compound.put("Inventory", (Tag)this.inventory.serializeNBT(registries));
        this.bakeData.write(compound, clientPacket);
    }

    protected void read(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        boolean changeOfController;
        assert (this.level != null);
        super.read(compound, registries, clientPacket);
        BlockPos controllerBefore = this.controller;
        int prevSize = this.radius;
        int prevHeight = this.height;
        this.updateConnectivity = compound.contains("Uninitialized");
        this.controller = null;
        this.lastKnownPos = null;
        if (compound.contains("LastKnownPos")) {
            this.lastKnownPos = NBTHelper.readBlockPos((CompoundTag)compound, (String)"LastKnownPos");
        }
        if (compound.contains("Controller")) {
            this.controller = NBTHelper.readBlockPos((CompoundTag)compound, (String)"Controller");
        }
        if (this.isController()) {
            this.radius = compound.getInt("Size");
            this.height = compound.getInt("Height");
        }
        this.inventory.deserializeNBT(registries, compound.getCompound("Inventory"));
        this.bakeData.read(compound, clientPacket);
        if (!clientPacket) {
            return;
        }
        boolean bl = changeOfController = !Objects.equals(controllerBefore, this.controller);
        if (this.hasLevel() && (changeOfController || prevSize != this.radius || prevHeight != this.height)) {
            this.level.setBlocksDirty(this.getBlockPos(), Blocks.AIR.defaultBlockState(), this.getBlockState());
            if (this.hasLevel()) {
                this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 16);
            }
            this.invalidateRenderBoundingBox();
        }
    }

    public BlockPos getController() {
        return this.isController() ? this.worldPosition : this.controller;
    }

    public OvenBlockEntity getControllerBE() {
        assert (this.level != null);
        if (this.isController()) {
            return this;
        }
        BlockEntity blockEntity = this.level.getBlockEntity(this.controller);
        if (blockEntity instanceof OvenBlockEntity) {
            OvenBlockEntity ovenBlockEntity = (OvenBlockEntity)blockEntity;
            return ovenBlockEntity;
        }
        return null;
    }

    public boolean isController() {
        return this.controller == null || this.worldPosition.equals((Object)this.controller);
    }

    public void setController(BlockPos pos) {
        assert (this.level != null);
        if (this.level.isClientSide && !this.isVirtual()) {
            return;
        }
        if (pos.equals((Object)this.controller)) {
            return;
        }
        this.controller = pos;
        this.refreshCapability();
        this.setChanged();
        this.sendData();
    }

    public void removeController(boolean keepContents) {
        assert (this.level != null);
        if (this.level.isClientSide()) {
            return;
        }
        this.updateConnectivity = true;
        this.controller = null;
        this.radius = 1;
        this.height = 1;
        this.refreshCapability();
        this.bakeData.clear();
        this.setChanged();
        this.sendData();
    }

    public BlockPos getLastKnownPos() {
        return this.lastKnownPos;
    }

    public void preventConnectivityUpdate() {
        this.updateConnectivity = false;
    }

    public void notifyMultiUpdated() {
        assert (this.level != null);
        this.level.setBlock(this.getBlockPos(), (BlockState)this.getBlockState().setValue((Property)OvenBlock.IS_2x2, (Comparable)Boolean.valueOf(this.getWidth() == 2)), 6);
        this.refreshCapability();
        this.updateOvenState();
        this.setChanged();
    }

    public Direction.Axis getMainConnectionAxis() {
        return Direction.Axis.Y;
    }

    public int getMaxLength(Direction.Axis longAxis, int width) {
        if (longAxis == Direction.Axis.Y) {
            return 7;
        }
        return this.getMaxWidth();
    }

    public int getMaxWidth() {
        return 3;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public int getWidth() {
        return this.radius;
    }

    public void setWidth(int width) {
        this.radius = width;
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        OvenBlockEntity controllerBE = this.getControllerBE();
        if (controllerBE == null) {
            return false;
        }
        return controllerBE.bakeData.addToGoggleTooltip(tooltip, isPlayerSneaking, controllerBE.getTotalOvenSize());
    }

    public int getTotalOvenSize() {
        return this.radius * this.radius * this.height;
    }

    public void updateOvenState() {
        if (!this.isController() && this.getControllerBE() != null) {
            this.getControllerBE().updateOvenState();
            return;
        }
        if (this.bakeData.evaluate(this)) {
            this.notifyUpdate();
        }
    }

    public void updateBakeData() {
        OvenBlockEntity be = this.getControllerBE();
        if (be == null) {
            return;
        }
        be.bakeData.updateRequired = 2;
    }

    private void initCapability() {
        assert (this.level != null);
        if (this.itemCapability != null) {
            return;
        }
        if (!this.isController()) {
            OvenBlockEntity controllerBE = this.getControllerBE();
            if (controllerBE == null) {
                return;
            }
            controllerBE.initCapability();
            this.itemCapability = controllerBE.itemCapability;
            return;
        }
        IItemHandlerModifiable[] invs = new IItemHandlerModifiable[this.height * this.radius * this.radius];
        this.inventories = new ArrayList<List<List<Inventory>>>();
        for (int xOffset = 0; xOffset < this.radius; ++xOffset) {
            ArrayList x = new ArrayList();
            this.inventories.add(x);
            for (int yOffset = 0; yOffset < this.height; ++yOffset) {
                ArrayList<Inventory> y = new ArrayList<Inventory>();
                x.add(y);
                for (int zOffset = 0; zOffset < this.radius; ++zOffset) {
                    BlockPos vaultPos = this.worldPosition.offset(xOffset, yOffset, zOffset);
                    OvenBlockEntity vaultAt = (OvenBlockEntity)ConnectivityHandler.partAt((BlockEntityType)((BlockEntityType)CRBlockEntityTypes.OVEN_ENTITY.get()), (BlockGetter)this.level, (BlockPos)vaultPos);
                    Inventory inv = vaultAt != null ? vaultAt.inventory : new Inventory();
                    invs[yOffset * this.radius * this.radius + xOffset * this.radius + zOffset] = inv;
                    y.add(inv);
                }
            }
        }
        this.itemCapability = new CombinedInvWrapper(invs);
    }

    @MethodsReturnNonnullByDefault
    @ParametersAreNonnullByDefault
    public class Inventory
    extends ItemStackHandler {
        public int tickTillFinishCooking = -1;
        public Recipe<?> lastRecipe = null;

        @NotNull
        public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
            assert (OvenBlockEntity.this.level != null);
            ItemStack returnValue = super.insertItem(slot, stack, simulate);
            if (!simulate && returnValue.getCount() != stack.getCount()) {
                SingleRecipeInput singleInputInv = new SingleRecipeInput(stack);
                Optional bakingOpt = CRRecipeTypes.BAKING.find(singleInputInv, OvenBlockEntity.this.level);
                if (bakingOpt.isPresent()) {
                    BakingRecipe bakingRecipe = (BakingRecipe)bakingOpt.get().value();
                    this.tickTillFinishCooking = bakingRecipe.getProcessingDuration() * ((this.getStackInSlot(slot).getCount() - 1) / 16 + 1);
                    this.lastRecipe = bakingRecipe;
                    return returnValue;
                }
                Optional smokingOpt = OvenBlockEntity.this.level.getRecipeManager().getRecipeFor(RecipeType.SMOKING, (RecipeInput)singleInputInv, OvenBlockEntity.this.level);
                if (smokingOpt.isPresent()) {
                    SmokingRecipe smokingRecipe = (SmokingRecipe)((RecipeHolder)smokingOpt.get()).value();
                    this.tickTillFinishCooking = smokingRecipe.getCookingTime() * ((this.getStackInSlot(slot).getCount() - 1) / 16 + 1);
                    this.lastRecipe = smokingRecipe;
                }
            }
            return returnValue;
        }

        @NotNull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (!simulate) {
                this.tickTillFinishCooking = -1;
            }
            return super.extractItem(slot, amount, simulate);
        }

        public int getSlotLimit(int slot) {
            return 16;
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            assert (OvenBlockEntity.this.level != null);
            SingleRecipeInput singleInputInv = new SingleRecipeInput(stack);
            return CRRecipeTypes.BAKING.find(singleInputInv, OvenBlockEntity.this.level).isPresent() || OvenBlockEntity.this.level.getRecipeManager().getRecipeFor(RecipeType.SMOKING, (RecipeInput)singleInputInv, OvenBlockEntity.this.level).isPresent();
        }

        public CompoundTag serializeNBT(HolderLookup.Provider provider) {
            CompoundTag tag = super.serializeNBT(provider);
            tag.putInt("tickTillFinishCooking", this.tickTillFinishCooking);
            return tag;
        }

        public void deserializeNBT(HolderLookup.Provider provider, CompoundTag nbt) {
            assert (OvenBlockEntity.this.level != null);
            super.deserializeNBT(provider, nbt);
            if (nbt.contains("tickTillFinishCooking")) {
                this.tickTillFinishCooking = nbt.getInt("tickTillFinishCooking");
            }
        }

        protected void onContentsChanged(int slot) {
            assert (OvenBlockEntity.this.level != null);
            if (!((OvenBlockEntity)OvenBlockEntity.this).level.isClientSide) {
                OvenBlockEntity.this.setChanged();
                OvenBlockEntity.this.sendData();
                OvenBlockEntity.this.notifyUpdate();
            }
        }
    }
}

