/*
 * Decompiled with CFR 0.152.
 */
package org.forsteri.ratatouille.content.spreader;

import com.simibubi.create.content.kinetics.base.DirectionalKineticBlock;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.fan.AirCurrent;
import com.simibubi.create.content.kinetics.fan.IAirCurrentSource;
import com.simibubi.create.content.kinetics.fan.NozzleBlockEntity;
import com.simibubi.create.content.logistics.chute.ChuteBlockEntity;
import com.simibubi.create.foundation.item.ItemHelper;
import com.simibubi.create.infrastructure.config.AllConfigs;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.AirBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.GrassBlock;
import net.minecraft.world.level.block.TallGrassBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.items.wrapper.CombinedInvWrapper;
import org.forsteri.ratatouille.entry.CRBlockEntityTypes;
import org.forsteri.ratatouille.entry.CRItems;
import org.jetbrains.annotations.NotNull;

@MethodsReturnNonnullByDefault
public class SpreaderBlockEntity
extends KineticBlockEntity
implements IAirCurrentSource {
    public int timer = 1000;
    public ItemStackHandler inventory;
    public IItemHandler capability;
    public AirCurrent airCurrent = new AirCurrent((IAirCurrentSource)this);
    protected int airCurrentUpdateCooldown;
    protected int entitySearchCooldown;
    protected boolean updateAirFlow = true;

    public SpreaderBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.inventory = new ItemStackHandler(1);
        this.capability = new SpreaderInventoryHandler(this);
    }

    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)CRBlockEntityTypes.OVEN_ENTITY.get(), (be, context) -> be.itemCapability);
    }

    public void invalidate() {
        super.invalidate();
        this.capability = null;
        this.invalidateCapabilities();
    }

    public void destroy() {
        super.destroy();
        ItemHelper.dropContents((Level)this.level, (BlockPos)this.worldPosition, (IItemHandler)this.inventory);
    }

    public AirCurrent getAirCurrent() {
        return this.airCurrent;
    }

    @Nullable
    public Level getAirCurrentWorld() {
        return this.level;
    }

    public BlockPos getAirCurrentPos() {
        return this.worldPosition;
    }

    public Direction getAirflowOriginSide() {
        return (Direction)this.getBlockState().getValue((Property)DirectionalKineticBlock.FACING);
    }

    public Direction getAirFlowDirection() {
        float speed = this.getSpeed();
        if (speed == 0.0f) {
            return null;
        }
        Direction facing = (Direction)this.getBlockState().getValue((Property)BlockStateProperties.FACING);
        return (speed = SpreaderBlockEntity.convertToDirection((float)speed, (Direction)facing)) > 0.0f ? facing : facing.getOpposite();
    }

    public boolean isSourceRemoved() {
        return this.remove;
    }

    public void blockInFrontChanged() {
        this.updateAirFlow = true;
    }

    public void tick() {
        block14: {
            ItemStack stack;
            ArrayList babyAnimals;
            ArrayList adultAnimals;
            block16: {
                int range;
                block15: {
                    boolean server;
                    super.tick();
                    boolean bl = server = !this.level.isClientSide || this.isVirtual();
                    if (server && this.airCurrentUpdateCooldown-- <= 0) {
                        this.airCurrentUpdateCooldown = (Integer)AllConfigs.server().kinetics.fanBlockCheckRate.get();
                        this.updateAirFlow = true;
                    }
                    if (this.updateAirFlow) {
                        this.updateAirFlow = false;
                        this.airCurrent.rebuild();
                        this.sendData();
                    }
                    if (this.getSpeed() == 0.0f) {
                        return;
                    }
                    if (this.entitySearchCooldown-- <= 0) {
                        this.entitySearchCooldown = 5;
                        this.airCurrent.findEntities();
                    }
                    this.airCurrent.tick();
                    if (this.level.isClientSide || this.inventory.getStackInSlot(0).isEmpty() || this.level.getServer() == null) break block14;
                    if (this.timer <= 0) break block15;
                    this.timer -= this.getProcessingSpeed();
                    break block14;
                }
                this.timer = 1000;
                ArrayList<BlockPos> corps = new ArrayList<BlockPos>();
                adultAnimals = new ArrayList();
                babyAnimals = new ArrayList();
                BlockPos facingPos = this.getBlockPos().relative((Direction)this.getBlockState().getValue((Property)DirectionalKineticBlock.FACING));
                boolean hasNozzle = this.level.getBlockEntity(facingPos) instanceof NozzleBlockEntity;
                int n = range = hasNozzle ? (int)(this.getMaxDistance() / 2.0f) : (int)this.airCurrent.maxDistance;
                if (hasNozzle) {
                    BlockPos min = facingPos.offset(-range, -range, -range);
                    BlockPos max = facingPos.offset(range, range, range);
                    for (BlockPos pos : BlockPos.betweenClosed((BlockPos)min, (BlockPos)max)) {
                        this.addCorpBuffer(corps, new BlockPos((Vec3i)pos));
                    }
                    aabb = new AABB(min.getCenter(), max.getCenter());
                    this.level.getEntitiesOfClass(Animal.class, aabb).forEach(animal -> {
                        if (!animal.isBaby() && !animal.isInLove()) {
                            adultAnimals.add(animal);
                        }
                        if (animal.isBaby()) {
                            babyAnimals.add(animal);
                        }
                    });
                } else {
                    for (int i = 1; i < range; ++i) {
                        BlockPos corpPos = this.getBlockPos().relative(this.airCurrent.direction, i);
                        this.addCorpBuffer(corps, corpPos);
                        aabb = new AABB(corpPos).inflate(0.5);
                        this.level.getEntitiesOfClass(Animal.class, aabb).forEach(animal -> {
                            if (!animal.isBaby() && !animal.isInLove()) {
                                adultAnimals.add(animal);
                            }
                            if (animal.isBaby()) {
                                babyAnimals.add(animal);
                            }
                        });
                    }
                }
                stack = this.inventory.getStackInSlot(0);
                if (!stack.is((Item)CRItems.RIPEN_MATTER.get())) break block16;
                if (corps.isEmpty()) break block14;
                stack.shrink(1);
                for (int count = this.getProcessingLevel(); count > 0; --count) {
                    BonemealableBlock growable;
                    BlockPos corpPos = corps.get(this.level.random.nextInt(0, corps.size()));
                    BlockState corpState = this.level.getBlockState(corpPos);
                    Block block = corpState.getBlock();
                    if (!(block instanceof BonemealableBlock) || !(growable = (BonemealableBlock)block).isValidBonemealTarget((LevelReader)this.level, corpPos, corpState)) continue;
                    growable.performBonemeal(this.level.getServer().overworld(), this.level.random, corpPos, corpState);
                    this.level.levelEvent(2005, corpPos, 0);
                }
                break block14;
            }
            if (!(!stack.is((Item)CRItems.MATURE_MATTER.get()) || adultAnimals.isEmpty() && babyAnimals.isEmpty())) {
                stack.shrink(1);
                for (int count = this.getProcessingLevel(); count > 0; --count) {
                    Animal target;
                    boolean tryAdultFirst = this.level.random.nextBoolean();
                    if (tryAdultFirst) {
                        if (!adultAnimals.isEmpty()) {
                            target = (Animal)adultAnimals.get(this.level.random.nextInt(adultAnimals.size()));
                            if (target.isInLove()) continue;
                            target.setInLove(null);
                            continue;
                        }
                        if (babyAnimals.isEmpty()) continue;
                        target = (AgeableMob)babyAnimals.get(this.level.random.nextInt(babyAnimals.size()));
                        target.ageUp(Animal.getSpeedUpSecondsWhenFeeding((int)(-target.getAge())), true);
                        continue;
                    }
                    if (!babyAnimals.isEmpty()) {
                        target = (AgeableMob)babyAnimals.get(this.level.random.nextInt(babyAnimals.size()));
                        target.ageUp(Animal.getSpeedUpSecondsWhenFeeding((int)(-target.getAge())), true);
                        continue;
                    }
                    if (adultAnimals.isEmpty() || (target = (Animal)adultAnimals.get(this.level.random.nextInt(adultAnimals.size()))).isInLove()) continue;
                    target.setInLove(null);
                }
            }
        }
    }

    public int getProcessingSpeed() {
        return Mth.clamp((int)((int)Math.abs(this.getSpeed() / 16.0f)), (int)1, (int)512);
    }

    public void addCorpBuffer(ArrayList<BlockPos> corps, BlockPos corpPos) {
        BonemealableBlock growable;
        Block block;
        BlockState corpState = this.level.getBlockState(corpPos);
        if (!(corpState.getBlock() instanceof AirBlock) && !(corpState.getBlock() instanceof GrassBlock) && !(corpState.getBlock() instanceof TallGrassBlock) && (block = corpState.getBlock()) instanceof BonemealableBlock && (growable = (BonemealableBlock)block).isValidBonemealTarget((LevelReader)this.level, corpPos, corpState)) {
            corps.add(corpPos);
        }
    }

    public int getProcessingLevel() {
        int speed = this.getProcessingSpeed();
        if (1 <= speed && speed < 4) {
            return 2;
        }
        if (4 <= speed && speed < 8) {
            return 3;
        }
        if (8 <= speed && speed < 12) {
            return 4;
        }
        return 5;
    }

    public float calculateStressApplied() {
        return 2.0f;
    }

    public void onSpeedChanged(float prevSpeed) {
        super.onSpeedChanged(prevSpeed);
        this.updateAirFlow = true;
        this.updateChute();
    }

    public void remove() {
        super.remove();
        this.updateChute();
    }

    protected void write(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        super.write(compound, registries, clientPacket);
        compound.putInt("Timer", this.timer);
        compound.put("Inventory", (Tag)this.inventory.serializeNBT(registries));
    }

    protected void read(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        super.read(compound, registries, clientPacket);
        if (clientPacket) {
            this.airCurrent.rebuild();
        }
        this.timer = compound.getInt("Timer");
        this.inventory.deserializeNBT(registries, compound.getCompound("Inventory"));
    }

    public void updateChute() {
        Direction direction = (Direction)this.getBlockState().getValue((Property)DirectionalKineticBlock.FACING);
        if (!direction.getAxis().isVertical()) {
            return;
        }
        BlockEntity poweredChute = this.level.getBlockEntity(this.worldPosition.relative(direction));
        if (!(poweredChute instanceof ChuteBlockEntity)) {
            return;
        }
        ChuteBlockEntity chuteBE = (ChuteBlockEntity)poweredChute;
        if (direction == Direction.DOWN) {
            chuteBE.updatePull();
        } else {
            chuteBE.updatePush(1);
        }
    }

    public int getParticleColor() {
        ItemStack stack = this.inventory.getStackInSlot(0);
        if (stack.is((Item)CRItems.MATURE_MATTER.get())) {
            return 12924160;
        }
        if (stack.is((Item)CRItems.RIPEN_MATTER.get())) {
            return 10599777;
        }
        return 0xFFFFFF;
    }

    private class SpreaderInventoryHandler
    extends CombinedInvWrapper {
        public SpreaderInventoryHandler(SpreaderBlockEntity spreaderBlockEntity) {
            super(new IItemHandlerModifiable[]{spreaderBlockEntity.inventory});
        }

        @NotNull
        public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
            if (!this.isItemValid(slot, stack)) {
                return stack;
            }
            return super.insertItem(slot, stack, simulate);
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            return stack.is((Item)CRItems.RIPEN_MATTER.get()) || stack.is((Item)CRItems.MATURE_MATTER.get());
        }
    }
}

