/*
 * Decompiled with CFR 0.152.
 */
package org.forsteri.ratatouille.content.spreader;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ExplodeParticle;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.SpriteSet;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.forsteri.ratatouille.content.spreader.SpreaderParticleData;

@OnlyIn(value=Dist.CLIENT)
public class SpreaderParticle
extends ExplodeParticle {
    public SpreaderParticle(ClientLevel pLevel, double pX, double pY, double pZ, double pXSpeed, double pYSpeed, double pZSpeed, SpriteSet pSprites, int color) {
        super(pLevel, pX, pY, pZ, pXSpeed, pYSpeed, pZSpeed, pSprites);
        this.setColor(color);
        this.setAlpha(1.0f);
    }

    public void setColor(int pColor) {
        float f = (float)((pColor & 0xFF0000) >> 16) / 255.0f;
        float f1 = (float)((pColor & 0xFF00) >> 8) / 255.0f;
        float f2 = (float)((pColor & 0xFF) >> 0) / 255.0f;
        this.setColor(f * 1.0f, f1 * 1.0f, f2 * 1.0f);
    }

    public static class Factory
    implements ParticleProvider<SpreaderParticleData> {
        private final SpriteSet spriteSet;

        public Factory(SpriteSet animatedSprite) {
            this.spriteSet = animatedSprite;
        }

        public Particle createParticle(SpreaderParticleData data, ClientLevel worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new SpreaderParticle(worldIn, x, y, z, xSpeed, ySpeed, zSpeed, this.spriteSet, data.color);
        }
    }
}

