/*
 * Decompiled with CFR 0.152.
 */
package org.forsteri.ratatouille.content.thresher;

import com.simibubi.create.content.kinetics.base.HorizontalKineticBlock;
import com.simibubi.create.foundation.block.IBE;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import org.forsteri.ratatouille.content.thresher.ThresherBlockEntity;
import org.forsteri.ratatouille.entry.CRBlockEntityTypes;
import org.forsteri.ratatouille.entry.CRBlocks;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class ThresherBlock
extends HorizontalKineticBlock
implements IBE<ThresherBlockEntity> {
    public ThresherBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public boolean hasShaftTowards(LevelReader world, BlockPos pos, BlockState state, Direction face) {
        return this.getRotationAxis(state) == face.getAxis();
    }

    public Direction.Axis getRotationAxis(BlockState state) {
        return ((Direction)state.getValue(HORIZONTAL_FACING)).getClockWise().getAxis();
    }

    public Class<ThresherBlockEntity> getBlockEntityClass() {
        return ThresherBlockEntity.class;
    }

    public BlockEntityType<? extends ThresherBlockEntity> getBlockEntityType() {
        return (BlockEntityType)CRBlockEntityTypes.THRESHER_ENTITY.get();
    }

    public void updateEntityAfterFallOn(BlockGetter worldIn, Entity entityIn) {
        super.updateEntityAfterFallOn(worldIn, entityIn);
        if (!CRBlocks.THRESHER.has(worldIn.getBlockState(entityIn.blockPosition()))) {
            return;
        }
        if (!(entityIn instanceof ItemEntity)) {
            return;
        }
        ItemEntity itemEntity = (ItemEntity)entityIn;
        if (!entityIn.isAlive()) {
            return;
        }
        this.withBlockEntityDo(worldIn, entityIn.blockPosition(), be -> {
            if (be.capability != null) {
                ItemStack insertItem = ItemHandlerHelper.insertItem((IItemHandler)be.capability, (ItemStack)itemEntity.getItem().copy(), (boolean)false);
                if (insertItem.isEmpty()) {
                    itemEntity.discard();
                    return;
                }
                itemEntity.setItem(insertItem);
            }
        });
    }

    protected boolean isPathfindable(BlockState state, PathComputationType pathComputationType) {
        return false;
    }

    public VoxelShape getShape(BlockState pState, BlockGetter p_60556_, BlockPos p_60557_, CollisionContext p_60558_) {
        boolean isZ = ((Direction)pState.getValue(HORIZONTAL_FACING)).getAxis() == Direction.Axis.Z;
        return Shapes.or((VoxelShape)Shapes.create((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.125, (double)1.0), (VoxelShape)Shapes.create((double)(isZ ? 0.0 : 0.0625), (double)0.125, (double)(isZ ? 0.0625 : 0.0), (double)(isZ ? 1.0 : 0.9375), (double)0.9375, (double)(isZ ? 0.9375 : 1.0)));
    }
}

