/*
 * Decompiled with CFR 0.152.
 */
package org.forsteri.ratatouille.content.thresher;

import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.belt.BeltBlockEntity;
import com.simibubi.create.content.kinetics.belt.behaviour.DirectBeltInputBehaviour;
import com.simibubi.create.content.logistics.funnel.FunnelBlock;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BehaviourType;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.inventory.InvManipulationBehaviour;
import com.simibubi.create.foundation.item.ItemHelper;
import java.util.List;
import java.util.Optional;
import javax.annotation.ParametersAreNonnullByDefault;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AirBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.items.wrapper.CombinedInvWrapper;
import net.neoforged.neoforge.items.wrapper.RecipeWrapper;
import org.forsteri.ratatouille.content.thresher.ThreshingRecipe;
import org.forsteri.ratatouille.entry.CRBlockEntityTypes;
import org.forsteri.ratatouille.entry.CRRecipeTypes;

public class ThresherBlockEntity
extends KineticBlockEntity {
    public ItemStackHandler inputInv = new ItemStackHandler(1);
    public ItemStackHandler outputInv = new ItemStackHandler(4);
    public IItemHandler capability = new ThresherInventoryHandler();
    public int timer;
    public ThreshingRecipe lastRecipe;

    public ThresherBlockEntity(BlockEntityType<?> typeIn, BlockPos pos, BlockState state) {
        super(typeIn, pos, state);
    }

    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)CRBlockEntityTypes.THRESHER_ENTITY.get(), (be, context) -> be.capability);
    }

    public void tick() {
        super.tick();
        if (this.level == null) {
            return;
        }
        if (this.getSpeed() == 0.0f) {
            return;
        }
        if (this.canOutput()) {
            Direction direction = this.getEjectDirection();
            for (int slot = 0; slot < this.outputInv.getSlots(); ++slot) {
                IItemHandler targetInv;
                InvManipulationBehaviour inserter;
                ItemStack stack = this.outputInv.getStackInSlot(slot);
                if (stack.isEmpty()) continue;
                BlockEntity be = this.level.getBlockEntity(this.worldPosition.below().relative(direction));
                InvManipulationBehaviour invManipulationBehaviour = inserter = be == null ? null : (InvManipulationBehaviour)BlockEntityBehaviour.get((BlockGetter)this.level, (BlockPos)be.getBlockPos(), (BehaviourType)InvManipulationBehaviour.TYPE);
                IItemHandler iItemHandler = be == null ? null : (targetInv = (IItemHandler)Optional.ofNullable((IItemHandler)this.level.getCapability(Capabilities.ItemHandler.BLOCK, be.getBlockPos(), (Object)direction.getOpposite())).orElse(inserter == null ? null : (IItemHandler)inserter.getInventory()));
                if (targetInv == null || !ItemHandlerHelper.insertItemStacked(targetInv, (ItemStack)stack, (boolean)true).isEmpty()) continue;
                ItemHandlerHelper.insertItemStacked(targetInv, (ItemStack)stack.copy(), (boolean)false);
                this.outputInv.setStackInSlot(slot, ItemStack.EMPTY);
                this.notifyUpdate();
            }
        } else if (this.level.getBlockState(this.getBlockPos().relative(this.getEjectDirection())).getBlock() instanceof AirBlock) {
            for (int slot = 0; slot < this.outputInv.getSlots(); ++slot) {
                ItemStack stack = this.outputInv.getStackInSlot(slot);
                if (stack.isEmpty()) continue;
                Vec3 neighbour = VecHelper.getCenterOf((Vec3i)this.getBlockPos().relative(this.getEjectDirection()));
                ItemEntity itementity = new ItemEntity(this.level, neighbour.x, (double)((float)Mth.floor((double)neighbour.y) + 0.0625f), neighbour.z, stack.split(this.level.random.nextInt(21) + 10));
                itementity.setDeltaMovement(Vec3.ZERO);
                this.level.addFreshEntity((Entity)itementity);
                this.outputInv.setStackInSlot(slot, ItemStack.EMPTY);
                this.notifyUpdate();
            }
        }
        for (int i = 0; i < this.outputInv.getSlots(); ++i) {
            if (this.outputInv.getStackInSlot(i).getCount() != this.outputInv.getSlotLimit(i)) continue;
            return;
        }
        if (this.timer > 0) {
            this.timer -= this.getProcessingSpeed();
            if (this.level.isClientSide) {
                this.spawnParticles();
                return;
            }
            if (this.timer <= 0) {
                this.process();
            }
            return;
        }
        if (this.inputInv.getStackInSlot(0).isEmpty()) {
            return;
        }
        RecipeWrapper inventoryIn = new RecipeWrapper((IItemHandler)this.inputInv);
        if (this.lastRecipe == null || !this.lastRecipe.matches((RecipeInput)inventoryIn, this.level)) {
            Optional recipe = CRRecipeTypes.THRESHING.find(inventoryIn, this.level);
            if (recipe.isEmpty()) {
                this.timer = 100;
            } else {
                this.lastRecipe = (ThreshingRecipe)recipe.get().value();
                this.timer = this.lastRecipe.getProcessingDuration();
            }
        } else {
            this.timer = this.lastRecipe.getProcessingDuration();
        }
        this.notifyUpdate();
    }

    private boolean canOutput() {
        DirectBeltInputBehaviour directBeltInputBehaviour;
        if (this.level == null) {
            return false;
        }
        Direction direction = this.getEjectDirection();
        BlockPos neighbour = this.getBlockPos().relative(direction);
        BlockPos output = neighbour.below();
        BlockState blockState = this.level.getBlockState(neighbour);
        if (FunnelBlock.isFunnel((BlockState)blockState)) {
            if (FunnelBlock.getFunnelFacing((BlockState)blockState) == direction) {
                return false;
            }
        } else {
            if (!blockState.getCollisionShape((BlockGetter)this.level, neighbour).isEmpty()) {
                return false;
            }
            BlockEntity blockEntity = this.level.getBlockEntity(output);
            if (blockEntity instanceof BeltBlockEntity) {
                BeltBlockEntity belt = (BeltBlockEntity)blockEntity;
                return belt.getSpeed() == 0.0f || belt.getMovementFacing() != direction.getOpposite();
            }
        }
        return (directBeltInputBehaviour = (DirectBeltInputBehaviour)BlockEntityBehaviour.get((BlockGetter)this.level, (BlockPos)output, (BehaviourType)DirectBeltInputBehaviour.TYPE)) != null && directBeltInputBehaviour.canInsertFromSide(direction);
    }

    public Direction getEjectDirection() {
        return (Direction)this.getBlockState().getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
    }

    public int getProcessingSpeed() {
        return Mth.clamp((int)((int)Math.abs(this.getSpeed() / 16.0f)), (int)1, (int)512);
    }

    public void spawnParticles() {
        if (this.level == null) {
            return;
        }
        ItemStack stackInSlot = this.inputInv.getStackInSlot(0);
        if (stackInSlot.isEmpty()) {
            return;
        }
        ItemParticleOption data = new ItemParticleOption(ParticleTypes.ITEM, stackInSlot);
        float angle = this.level.random.nextFloat() * 360.0f;
        Vec3 offset = new Vec3(0.0, 0.0, 0.5);
        offset = VecHelper.rotate((Vec3)offset, (double)angle, (Direction.Axis)Direction.Axis.Y);
        Vec3 target = VecHelper.rotate((Vec3)offset, (double)(this.getSpeed() > 0.0f ? 25.0 : -25.0), (Direction.Axis)Direction.Axis.Y);
        Vec3 center = offset.add(VecHelper.getCenterOf((Vec3i)this.worldPosition));
        target = VecHelper.offsetRandomly((Vec3)target.subtract(offset), (RandomSource)this.level.random, (float)0.0078125f);
        this.level.addParticle((ParticleOptions)data, center.x, center.y, center.z, target.x, target.y, target.z);
    }

    private void process() {
        if (this.level == null) {
            return;
        }
        RecipeWrapper inventoryIn = new RecipeWrapper((IItemHandler)this.inputInv);
        if (this.lastRecipe == null || !this.lastRecipe.matches((RecipeInput)inventoryIn, this.level)) {
            Optional recipe = CRRecipeTypes.THRESHING.find(inventoryIn, this.level);
            if (recipe.isEmpty()) {
                return;
            }
            this.lastRecipe = (ThreshingRecipe)recipe.get().value();
        }
        ItemStack stackInSlot = this.inputInv.getStackInSlot(0);
        stackInSlot.shrink(1);
        this.inputInv.setStackInSlot(0, stackInSlot);
        this.lastRecipe.rollResults().forEach(stack -> ItemHandlerHelper.insertItemStacked((IItemHandler)this.outputInv, (ItemStack)stack, (boolean)false));
        this.notifyUpdate();
    }

    public float calculateStressApplied() {
        return 4.0f;
    }

    protected void write(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        compound.putInt("Timer", this.timer);
        compound.put("InputInventory", (Tag)this.inputInv.serializeNBT(registries));
        compound.put("OutputInventory", (Tag)this.outputInv.serializeNBT(registries));
        super.write(compound, registries, clientPacket);
    }

    protected void read(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        this.timer = compound.getInt("Timer");
        this.inputInv.deserializeNBT(registries, compound.getCompound("InputInventory"));
        this.outputInv.deserializeNBT(registries, compound.getCompound("OutputInventory"));
        super.read(compound, registries, clientPacket);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        behaviours.add((BlockEntityBehaviour)new DirectBeltInputBehaviour((SmartBlockEntity)this));
        super.addBehaviours(behaviours);
    }

    public void invalidate() {
        super.invalidate();
        this.invalidateCapabilities();
    }

    public void destroy() {
        super.destroy();
        ItemHelper.dropContents((Level)this.level, (BlockPos)this.worldPosition, (IItemHandler)this.inputInv);
        ItemHelper.dropContents((Level)this.level, (BlockPos)this.worldPosition, (IItemHandler)this.outputInv);
    }

    private boolean canProcess(ItemStack stack) {
        if (this.level == null) {
            return false;
        }
        SingleRecipeInput inventoryIn = new SingleRecipeInput(stack);
        if (this.lastRecipe != null && this.lastRecipe.matches((RecipeInput)inventoryIn, this.level)) {
            return true;
        }
        return CRRecipeTypes.THRESHING.find(inventoryIn, this.level).isPresent();
    }

    @MethodsReturnNonnullByDefault
    @ParametersAreNonnullByDefault
    private class ThresherInventoryHandler
    extends CombinedInvWrapper {
        public ThresherInventoryHandler() {
            super(new IItemHandlerModifiable[]{ThresherBlockEntity.this.inputInv, ThresherBlockEntity.this.outputInv});
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            if (ThresherBlockEntity.this.outputInv == this.getHandlerFromIndex(this.getIndexForSlot(slot))) {
                return stack;
            }
            if (!this.isItemValid(slot, stack)) {
                return stack;
            }
            return super.insertItem(slot, stack, simulate);
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (ThresherBlockEntity.this.inputInv == this.getHandlerFromIndex(this.getIndexForSlot(slot))) {
                return ItemStack.EMPTY;
            }
            return super.extractItem(slot, amount, simulate);
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            if (ThresherBlockEntity.this.outputInv == this.getHandlerFromIndex(this.getIndexForSlot(slot))) {
                return false;
            }
            return ThresherBlockEntity.this.canProcess(stack) && super.isItemValid(slot, stack);
        }
    }
}

