/*
 * Decompiled with CFR 0.152.
 */
package org.forsteri.ratatouille.content.irrigation_tower;

import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.content.fluids.transfer.GenericItemEmptying;
import com.simibubi.create.content.fluids.transfer.GenericItemFilling;
import com.simibubi.create.foundation.block.IBE;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.fluid.FluidHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.ForgeFlowingFluid;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.forsteri.ratatouille.content.irrigation_tower.IrrigationTowerBlockEntity;
import org.forsteri.ratatouille.entry.CRBlockEntityTypes;
import org.forsteri.ratatouille.entry.CRFluids;
import org.jetbrains.annotations.NotNull;
import vectorwing.farmersdelight.common.registry.ModBlocks;

public class IrrigationTowerBlock
extends HorizontalDirectionalBlock
implements IWrenchable,
IBE<IrrigationTowerBlockEntity> {
    public IrrigationTowerBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties.m_60977_());
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return Shapes.m_166049_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)1.5, (double)1.0);
    }

    @NotNull
    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        ItemStack heldItem = pPlayer.m_21120_(pHand);
        return this.onBlockEntityUse((BlockGetter)pLevel, pPos, be -> {
            if (!heldItem.m_41619_()) {
                if (FluidHelper.tryEmptyItemIntoBE((Level)pLevel, (Player)pPlayer, (InteractionHand)pHand, (ItemStack)heldItem, (SmartBlockEntity)be)) {
                    return InteractionResult.SUCCESS;
                }
                if (FluidHelper.tryFillItemFromBE((Level)pLevel, (Player)pPlayer, (InteractionHand)pHand, (ItemStack)heldItem, (SmartBlockEntity)be)) {
                    return InteractionResult.SUCCESS;
                }
                if (!GenericItemEmptying.canItemBeEmptied((Level)pLevel, (ItemStack)heldItem) && !GenericItemFilling.canItemBeFilled((Level)pLevel, (ItemStack)heldItem)) {
                    return heldItem.m_41720_().equals(Items.f_41902_) && !be.getCapability(ForgeCapabilities.FLUID_HANDLER).map(iFluidHandler -> iFluidHandler.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.EXECUTE)).orElse(FluidStack.EMPTY).isEmpty() ? InteractionResult.SUCCESS : InteractionResult.PASS;
                }
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.FAIL;
        });
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.m_7926_(pBuilder.m_61104_(new Property[]{f_54117_}));
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        Direction preferredFacing = context.m_8125_().m_122424_();
        return (BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)(context.m_43723_() != null && context.m_43723_().m_6144_() ? preferredFacing : preferredFacing.m_122424_()));
    }

    public Class<IrrigationTowerBlockEntity> getBlockEntityClass() {
        return IrrigationTowerBlockEntity.class;
    }

    public BlockEntityType<? extends IrrigationTowerBlockEntity> getBlockEntityType() {
        return (BlockEntityType)CRBlockEntityTypes.IRRIGATION_TOWER_BLOCK_ENTITY.get();
    }

    public void m_213898_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (!(blockEntity instanceof IrrigationTowerBlockEntity)) {
            return;
        }
        IrrigationTowerBlockEntity tower = (IrrigationTowerBlockEntity)blockEntity;
        FluidStack simulate = tower.getTankInventory().drain(new FluidStack(((ForgeFlowingFluid.Flowing)CRFluids.COMPOST_TEA.get()).m_5613_(), 100), IFluidHandler.FluidAction.SIMULATE);
        if (simulate.isEmpty() || simulate.getAmount() < 100) {
            return;
        }
        BlockPos center = pos.m_7495_();
        for (int dx = -8; dx <= 8; ++dx) {
            for (int dy = -1; dy <= 1; ++dy) {
                for (int dz = -8; dz <= 8; ++dz) {
                    BlockPos target = center.m_7918_(dx, dy, dz);
                    BlockState targetState = level.m_8055_(target);
                    if (!targetState.m_60713_(Blocks.f_50093_)) continue;
                    BlockState newState = ((Block)ModBlocks.RICH_SOIL_FARMLAND.get()).m_49966_();
                    level.m_46597_(target, newState);
                    level.m_220407_(GameEvent.f_157792_, target, GameEvent.Context.m_223719_(null, (BlockState)newState));
                    tower.getTankInventory().drain(new FluidStack(((ForgeFlowingFluid.Flowing)CRFluids.COMPOST_TEA.get()).m_5613_(), 100), IFluidHandler.FluidAction.EXECUTE);
                    return;
                }
            }
        }
    }
}

