/*
 * Decompiled with CFR 0.152.
 */
package org.forsteri.ratatouille.content.oven_fan;

import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.content.kinetics.base.HorizontalKineticBlock;
import com.simibubi.create.content.kinetics.simpleRelays.ICogWheel;
import com.simibubi.create.foundation.block.IBE;
import java.util.List;
import java.util.function.Predicate;
import net.createmod.catnip.levelWrappers.WrappedLevel;
import net.createmod.catnip.placement.IPlacementHelper;
import net.createmod.catnip.placement.PlacementHelpers;
import net.createmod.catnip.placement.PlacementOffset;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.forsteri.ratatouille.content.oven_fan.OvenFanBlockEntity;
import org.forsteri.ratatouille.entry.CRBlockEntityTypes;
import org.forsteri.ratatouille.entry.CRBlocks;

public class OvenFanBlock
extends HorizontalKineticBlock
implements ICogWheel,
IWrenchable,
IBE<OvenFanBlockEntity> {
    private static final int placementHelperId = PlacementHelpers.register((IPlacementHelper)new PlacementHelper());

    public OvenFanBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        if (pPlayer.m_6144_()) {
            return InteractionResult.PASS;
        }
        ItemStack heldItem = pPlayer.m_21120_(pHand);
        IPlacementHelper placementHelper = PlacementHelpers.get((int)placementHelperId);
        if (placementHelper.matchesItem(heldItem)) {
            return placementHelper.getOffset(pPlayer, pLevel, pState, pPos, pHit).placeInWorld(pLevel, (BlockItem)heldItem.m_41720_(), pPlayer, pHand, pHit);
        }
        return InteractionResult.SUCCESS;
    }

    public void m_6807_(BlockState state, Level worldIn, BlockPos pos, BlockState oldState, boolean isMoving) {
        super.m_6807_(state, worldIn, pos, oldState, isMoving);
        this.blockUpdate(state, (LevelAccessor)worldIn, pos);
    }

    public void m_7742_(BlockState stateIn, LevelAccessor worldIn, BlockPos pos, int flags, int count) {
        super.m_7742_(stateIn, worldIn, pos, flags, count);
        this.blockUpdate(stateIn, worldIn, pos);
    }

    public void m_6861_(BlockState state, Level worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        this.blockUpdate(state, (LevelAccessor)worldIn, pos);
    }

    protected void blockUpdate(BlockState state, LevelAccessor worldIn, BlockPos pos) {
        if (!(worldIn instanceof WrappedLevel)) {
            this.notifyOvenFanBlockEntity(worldIn, pos);
        }
    }

    protected void notifyOvenFanBlockEntity(LevelAccessor world, BlockPos pos) {
        this.withBlockEntityDo((BlockGetter)world, pos, OvenFanBlockEntity::blockInFrontChanged);
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        Direction preferredFacing = this.getPreferredHorizontalFacing(context);
        if (preferredFacing == null) {
            preferredFacing = context.m_8125_();
        }
        return (BlockState)this.m_49966_().m_61124_(HORIZONTAL_FACING, (Comparable)(context.m_43723_() != null && context.m_43723_().m_6144_() ? preferredFacing : preferredFacing.m_122424_()));
    }

    public BlockState updateAfterWrenched(BlockState newState, UseOnContext context) {
        this.blockUpdate(newState, (LevelAccessor)context.m_43725_(), context.m_8083_());
        return newState;
    }

    public Direction.Axis getRotationAxis(BlockState blockState) {
        return ((Direction)blockState.m_61143_(HORIZONTAL_FACING)).m_122434_();
    }

    public boolean hasShaftTowards(LevelReader world, BlockPos pos, BlockState state, Direction face) {
        return face == ((Direction)state.m_61143_(HORIZONTAL_FACING)).m_122424_();
    }

    public Class<OvenFanBlockEntity> getBlockEntityClass() {
        return OvenFanBlockEntity.class;
    }

    public BlockEntityType<? extends OvenFanBlockEntity> getBlockEntityType() {
        return (BlockEntityType)CRBlockEntityTypes.OVEN_FAN_ENTITY.get();
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter p_60556_, BlockPos p_60557_, CollisionContext p_60558_) {
        Direction direction = (Direction)pState.m_61143_(HORIZONTAL_FACING);
        return switch (direction) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.WEST -> Shapes.m_166049_((double)0.0, (double)0.0, (double)0.0, (double)0.8125, (double)1.0, (double)1.0);
            case Direction.EAST -> Shapes.m_166049_((double)0.1875, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)1.0);
            case Direction.NORTH -> Shapes.m_166049_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)0.8125);
            case Direction.SOUTH -> Shapes.m_166049_((double)0.0, (double)0.0, (double)0.1875, (double)1.0, (double)1.0, (double)1.0);
            case Direction.UP, Direction.DOWN -> Shapes.m_83144_();
        };
    }

    @MethodsReturnNonnullByDefault
    private static class PlacementHelper
    implements IPlacementHelper {
        private PlacementHelper() {
        }

        public Predicate<ItemStack> getItemPredicate() {
            return arg_0 -> CRBlocks.OVEN_FAN.isIn(arg_0);
        }

        public Predicate<BlockState> getStatePredicate() {
            return arg_0 -> CRBlocks.OVEN_FAN.has(arg_0);
        }

        public PlacementOffset getOffset(Player player, Level world, BlockState state, BlockPos pos, BlockHitResult ray) {
            List directions = IPlacementHelper.orderedByDistanceExceptAxis((BlockPos)pos, (Vec3)ray.m_82450_(), (Direction.Axis)((Direction)state.m_61143_(HORIZONTAL_FACING)).m_122434_(), dir -> world.m_8055_(pos.m_121945_(dir)).m_247087_());
            return directions.isEmpty() ? PlacementOffset.fail() : PlacementOffset.success((Vec3i)pos.m_121945_((Direction)directions.get(0)), s -> (BlockState)s.m_61124_(HorizontalKineticBlock.HORIZONTAL_FACING, (Comparable)((Direction)state.m_61143_(HORIZONTAL_FACING))));
        }
    }
}

