/*
 * Decompiled with CFR 0.152.
 */
package org.forsteri.ratatouille.ponder;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.kinetics.belt.transport.TransportedItemStack;
import com.simibubi.create.content.logistics.depot.DepotBehaviour;
import com.simibubi.create.content.logistics.depot.DepotBlockEntity;
import com.simibubi.create.foundation.ponder.CreateSceneBuilder;
import net.createmod.ponder.api.scene.SceneBuilder;
import net.createmod.ponder.api.scene.SceneBuildingUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.forsteri.ratatouille.entry.CRItems;

public class SpreaderScene {
    private static void addGrowthParticles(SceneBuilder builder, BlockPos corpPos) {
        double d0 = 0.5;
        double d1 = 1.0;
        RandomSource randomsource = RandomSource.m_216327_();
        CreateSceneBuilder scene = new CreateSceneBuilder(builder);
        for (int i = 0; i < 15; ++i) {
            double d2 = randomsource.m_188583_() * 0.02;
            double d3 = randomsource.m_188583_() * 0.02;
            double d4 = randomsource.m_188583_() * 0.02;
            double d5 = 0.5 - d0;
            double d6 = (double)corpPos.m_123341_() + d5 + randomsource.m_188500_() * d0 * 2.0;
            double d7 = (double)corpPos.m_123342_() + randomsource.m_188500_() * d1;
            double d8 = (double)corpPos.m_123343_() + d5 + randomsource.m_188500_() * d0 * 2.0;
            scene.effects().emitParticles(new Vec3(d6, d7, d8), scene.effects().simpleParticleEmitter((ParticleOptions)ParticleTypes.f_123748_, new Vec3(d2, d3, d4)), 0.5f, 1);
        }
    }

    public static void spreader(SceneBuilder builder, SceneBuildingUtil util) {
        CreateSceneBuilder scene = new CreateSceneBuilder(builder);
        scene.title("spreader", "Accelerate Crop Growth with the Spreader");
        scene.configureBasePlate(0, 0, 5);
        scene.world().showSection(util.select().layer(0), Direction.UP);
        scene.world().showSection(util.select().fromTo(0, 1, 1, 1, 1, 3), Direction.UP);
        scene.idle(5);
        BlockPos spreaderPos = util.grid().at(3, 1, 2);
        BlockPos nozzlePos = util.grid().at(2, 1, 2);
        BlockPos depotPos = util.grid().at(3, 0, 1);
        BlockPos corpPos = util.grid().at(1, 1, 2);
        scene.world().setBlock(nozzlePos, Blocks.f_50016_.m_49966_(), false);
        scene.world().showSection(util.select().fromTo(5, 1, 1, 3, 1, 2), Direction.DOWN);
        scene.idle(10);
        scene.overlay().showText(60).text("The spreader rapidly ripens crops within its designated range").placeNearTarget().attachKeyFrame().pointAt(util.vector().topOf(spreaderPos));
        scene.idle(70);
        scene.world().modifyBlockEntity(depotPos, DepotBlockEntity.class, be -> ((DepotBehaviour)be.getBehaviour(DepotBehaviour.TYPE)).setHeldItem(new TransportedItemStack(new ItemStack((ItemLike)CRItems.RIPEN_MATTER.get(), 64))));
        scene.overlay().showText(60).text("Each grown action consumes one ripen matter").placeNearTarget().attachKeyFrame().pointAt(util.vector().topOf(spreaderPos));
        scene.idle(70);
        scene.world().createItemOnBeltLike(depotPos, Direction.UP, ItemStack.f_41583_);
        scene.world().modifyBlockEntity(depotPos, DepotBlockEntity.class, be -> ((DepotBehaviour)be.getBehaviour(DepotBehaviour.TYPE)).setHeldItem(new TransportedItemStack(ItemStack.f_41583_)));
        scene.world().setBlock(corpPos, (BlockState)Blocks.f_50092_.m_49966_().m_61124_((Property)CropBlock.f_52244_, (Comparable)Integer.valueOf(5)), false);
        SpreaderScene.addGrowthParticles((SceneBuilder)scene, corpPos);
        scene.idle(40);
        scene.world().setBlock(nozzlePos, (BlockState)AllBlocks.NOZZLE.getDefaultState().m_61124_((Property)DirectionalBlock.f_52588_, (Comparable)Direction.WEST), false);
        scene.world().showSection(util.select().fromTo(nozzlePos, nozzlePos), Direction.DOWN);
        scene.world().modifyKineticSpeed(util.select().everywhere(), f -> Float.valueOf(256.0f));
        scene.overlay().showText(60).text("By adjusting speed and attach nozzle, you can significantly expand the ripening area").placeNearTarget().attachKeyFrame().pointAt(util.vector().topOf(spreaderPos));
        scene.idle(70);
        scene.world().setBlock(util.grid().at(1, 1, 1), (BlockState)Blocks.f_50092_.m_49966_().m_61124_((Property)CropBlock.f_52244_, (Comparable)Integer.valueOf(3)), false);
        SpreaderScene.addGrowthParticles((SceneBuilder)scene, util.grid().at(1, 1, 1));
        scene.world().setBlock(util.grid().at(0, 1, 2), (BlockState)Blocks.f_50092_.m_49966_().m_61124_((Property)CropBlock.f_52244_, (Comparable)Integer.valueOf(2)), false);
        SpreaderScene.addGrowthParticles((SceneBuilder)scene, util.grid().at(0, 1, 2));
        scene.world().setBlock(util.grid().at(1, 1, 3), (BlockState)Blocks.f_50092_.m_49966_().m_61124_((Property)CropBlock.f_52244_, (Comparable)Integer.valueOf(3)), false);
        SpreaderScene.addGrowthParticles((SceneBuilder)scene, util.grid().at(1, 1, 3));
        scene.idle(40);
        scene.world().setBlock(util.grid().at(0, 1, 2), (BlockState)Blocks.f_50092_.m_49966_().m_61124_((Property)CropBlock.f_52244_, (Comparable)Integer.valueOf(6)), false);
        SpreaderScene.addGrowthParticles((SceneBuilder)scene, util.grid().at(0, 1, 2));
        scene.world().setBlock(util.grid().at(0, 1, 2), (BlockState)Blocks.f_50092_.m_49966_().m_61124_((Property)CropBlock.f_52244_, (Comparable)Integer.valueOf(4)), false);
        SpreaderScene.addGrowthParticles((SceneBuilder)scene, util.grid().at(0, 1, 2));
        scene.world().setBlock(util.grid().at(0, 1, 1), (BlockState)Blocks.f_50092_.m_49966_().m_61124_((Property)CropBlock.f_52244_, (Comparable)Integer.valueOf(3)), false);
        SpreaderScene.addGrowthParticles((SceneBuilder)scene, util.grid().at(0, 1, 1));
    }
}

