/*
 * Decompiled with CFR 0.152.
 */
package org.forsteri.ratatouille.content.compost_tower;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import org.forsteri.ratatouille.content.compost_tower.CompostFluidTank;
import org.forsteri.ratatouille.entry.CRFluids;
import org.forsteri.ratatouille.entry.CRItems;
import org.jetbrains.annotations.NotNull;

public class CompostItemHandler
implements IItemHandlerModifiable {
    private static final int ITEM_FLUID_RATIO = 80;
    private static final BiMap<Fluid, Item> ITEM_FLUID_MAP = HashBiMap.create();
    protected CompostFluidTank tank;

    CompostItemHandler(CompostFluidTank tank) {
        this.tank = tank;
    }

    public void setStackInSlot(int slot, @NotNull ItemStack stack) {
        this.tank.fill(this.itemToFluid(stack), IFluidHandler.FluidAction.EXECUTE);
    }

    private FluidStack itemToFluid(ItemStack itemStack) {
        int amount = itemStack.getCount() * 80;
        Item item = itemStack.getItem();
        if (amount == 0 || !ITEM_FLUID_MAP.inverse().containsKey((Object)item)) {
            return FluidStack.EMPTY;
        }
        return new FluidStack((Fluid)ITEM_FLUID_MAP.inverse().get((Object)item), amount);
    }

    public int getSlots() {
        return this.tank.getTanks();
    }

    @NotNull
    public ItemStack getStackInSlot(int slot) {
        return this.fluidToItem(this.tank.getFluidInTank(slot));
    }

    private ItemStack fluidToItem(FluidStack fluidStack) {
        int amount = fluidStack.getAmount() / 80;
        Fluid fluid = fluidStack.getFluid();
        if (amount == 0 || !ITEM_FLUID_MAP.containsKey((Object)fluid)) {
            return ItemStack.EMPTY;
        }
        return new ItemStack((ItemLike)ITEM_FLUID_MAP.get((Object)fluid), amount);
    }

    @NotNull
    public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
        IFluidHandler.FluidAction action = simulate ? IFluidHandler.FluidAction.SIMULATE : IFluidHandler.FluidAction.EXECUTE;
        int remaining = stack.getCount() - this.tank.fill(this.itemToFluid(stack), action);
        return new ItemStack((ItemLike)stack.getItem(), remaining);
    }

    @NotNull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        IFluidHandler.FluidAction action = simulate ? IFluidHandler.FluidAction.SIMULATE : IFluidHandler.FluidAction.EXECUTE;
        FluidStack targetFluid = this.tank.getFluidInTank(slot);
        FluidStack extracted = this.tank.drain(new FluidStack(targetFluid.getFluid(), amount), action);
        return this.fluidToItem(extracted);
    }

    public int getSlotLimit(int slot) {
        return this.tank.getTankCapacity(slot);
    }

    public boolean isItemValid(int slot, @NotNull ItemStack stack) {
        FluidStack fluid = this.itemToFluid(stack);
        if (fluid.isEmpty()) {
            return false;
        }
        return this.tank.getFluidInTank(slot).is(fluid.getFluid());
    }

    public void consume(ItemStack item, boolean simulate) {
        FluidStack fluid = this.itemToFluid(item);
        if (fluid.isEmpty()) {
            return;
        }
        if (this.tank.drain(fluid, IFluidHandler.FluidAction.SIMULATE).getAmount() >= fluid.getAmount()) {
            this.tank.drain(fluid, IFluidHandler.FluidAction.EXECUTE);
        }
    }

    static {
        ITEM_FLUID_MAP.put((Object)((Fluid)CRFluids.COMPOST_FLUID.get()), (Object)((Item)CRItems.COMPOST_MASS.get()));
    }
}

