/*
 * Decompiled with CFR 0.152.
 */
package org.forsteri.ratatouille.content.demolder;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.KineticBlockEntityRenderer;
import com.simibubi.create.content.kinetics.belt.BeltHelper;
import com.simibubi.create.content.kinetics.press.PressingBehaviour;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import net.createmod.catnip.render.CachedBuffers;
import net.createmod.catnip.render.SuperByteBuffer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.forsteri.ratatouille.content.demolder.MechanicalDemolderBlockEntity;
import org.forsteri.ratatouille.entry.CRPartialModels;

public class MechanicalDemolderRenderer
extends KineticBlockEntityRenderer<MechanicalDemolderBlockEntity> {
    public MechanicalDemolderRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    protected void renderSafe(MechanicalDemolderBlockEntity be, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        super.renderSafe((KineticBlockEntity)be, partialTicks, ms, buffer, light, overlay);
        BlockState blockState = be.getBlockState();
        PressingBehaviour pressingBehaviour = be.getPressingBehaviour();
        float renderedHeadOffset = pressingBehaviour.getRenderedHeadOffset(partialTicks) * pressingBehaviour.mode.headOffset;
        SuperByteBuffer headRender = CachedBuffers.partialFacing((PartialModel)CRPartialModels.MECHANICAL_DEMOLDER_HEAD, (BlockState)blockState, (Direction)((Direction)blockState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)));
        ((SuperByteBuffer)headRender.translate(0.0f, -renderedHeadOffset, 0.0f)).light(light).renderInto(ms, buffer.getBuffer(RenderType.solid()));
        ItemStack itemStack = be.outputInv.getStackInSlot(0);
        ItemRenderer itemRenderer = Minecraft.getInstance().getItemRenderer();
        boolean renderUpright = BeltHelper.isItemUpright((ItemStack)itemStack);
        int count = Mth.log2((int)itemStack.getCount()) / 2;
        ms.pushPose();
        ms.translate(0.5, (double)(-renderedHeadOffset) + 0.0625, 0.5);
        for (int i = 0; i <= count; ++i) {
            ms.pushPose();
            if (!renderUpright) {
                ms.translate(0.0, -0.09375, 0.0);
                ms.mulPose(Axis.XP.rotationDegrees(90.0f));
            }
            ms.scale(0.5f, 0.5f, 0.5f);
            itemRenderer.renderStatic(null, itemStack, ItemDisplayContext.FIXED, false, ms, buffer, be.getLevel(), light, overlay, 0);
            ms.popPose();
            if (!renderUpright) {
                ms.mulPose(Axis.YP.rotationDegrees(10.0f));
                ms.translate(0.0, -0.0625, 0.0);
                continue;
            }
            ms.translate(0.0f, 0.0f, -0.0625f);
        }
        ms.popPose();
    }

    protected BlockState getRenderedBlockState(MechanicalDemolderBlockEntity be) {
        return MechanicalDemolderRenderer.shaft((Direction.Axis)MechanicalDemolderRenderer.getRotationAxisOf((KineticBlockEntity)be));
    }
}

