/*
 * Decompiled with CFR 0.152.
 */
package org.forsteri.ratatouille.content.oven;

import com.simibubi.create.api.connectivity.ConnectivityHandler;
import com.simibubi.create.content.fluids.tank.FluidTankCTBehaviour;
import com.simibubi.create.content.fluids.tank.FluidTankGenerator;
import com.simibubi.create.content.kinetics.fan.EncasedFanBlock;
import com.simibubi.create.foundation.block.connected.CTModel;
import com.simibubi.create.foundation.block.connected.CTSpriteShiftEntry;
import com.simibubi.create.foundation.block.connected.ConnectedTextureBehaviour;
import com.tterrag.registrate.providers.DataGenContext;
import com.tterrag.registrate.providers.RegistrateBlockstateProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.createmod.catnip.data.Iterate;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.client.model.data.ModelProperty;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import org.forsteri.ratatouille.content.oven.OvenBlock;
import org.forsteri.ratatouille.entry.CRSpriteShifts;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OvenModel
extends CTModel {
    protected static final ModelProperty<CullData> CULL_PROPERTY = new ModelProperty();

    public OvenModel(BakedModel originalModel, CTSpriteShiftEntry side, CTSpriteShiftEntry top, CTSpriteShiftEntry topInner, CTSpriteShiftEntry bottom, CTSpriteShiftEntry bottomInner, CTSpriteShiftEntry shift2x2) {
        super(originalModel, (ConnectedTextureBehaviour)new OvenCTBehavior(side, top, topInner, bottom, bottomInner, shift2x2));
    }

    public static OvenModel standard(BakedModel originalModel) {
        return new OvenModel(originalModel, CRSpriteShifts.OVEN_SPRITE, CRSpriteShifts.OVEN_SPRITE_TOP, CRSpriteShifts.OVEN_SPRITE_TOP_INNER, CRSpriteShifts.OVEN_SPRITE_BOTTOM, CRSpriteShifts.OVEN_SPRITE_BOTTOM_INNER, CRSpriteShifts.OVEN_SPRITE_SHIFT_2x2);
    }

    protected ModelData.Builder gatherModelData(ModelData.Builder builder, BlockAndTintGetter world, BlockPos pos, BlockState state, ModelData blockEntityData) {
        super.gatherModelData(builder, world, pos, state, blockEntityData);
        CullData cullData = new CullData();
        for (Direction d : Iterate.directions) {
            cullData.setCulled(d, ConnectivityHandler.isConnected((BlockGetter)world, (BlockPos)pos, (BlockPos)pos.relative(d)) || world.getBlockState(pos.relative(d)).getBlock() instanceof EncasedFanBlock && world.getBlockState(pos.relative(d)).getValue((Property)EncasedFanBlock.FACING) == d.getOpposite());
        }
        cullData.setCulled(null, !ConnectivityHandler.isConnected((BlockGetter)world, (BlockPos)pos, (BlockPos)pos.above()) && !ConnectivityHandler.isConnected((BlockGetter)world, (BlockPos)pos, (BlockPos)pos.below()));
        return builder.with(CULL_PROPERTY, (Object)cullData);
    }

    @NotNull
    public List<BakedQuad> getQuads(BlockState state, Direction side, RandomSource rand, ModelData extraData, RenderType renderType) {
        if (side != null) {
            return Collections.emptyList();
        }
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        for (Direction d : Iterate.directions) {
            if (extraData.has(CULL_PROPERTY) && Objects.requireNonNull((CullData)extraData.get(CULL_PROPERTY)).isCulled(d)) continue;
            quads.addAll(super.getQuads(state, d, rand, extraData, renderType));
        }
        if (extraData.has(CULL_PROPERTY) && !Objects.requireNonNull((CullData)extraData.get(CULL_PROPERTY)).isCulled(null)) {
            quads.addAll(super.getQuads(state, null, rand, extraData, renderType));
        }
        return quads;
    }

    public static class OvenCTBehavior
    extends FluidTankCTBehaviour {
        private final CTSpriteShiftEntry bottomShift;
        private final CTSpriteShiftEntry bottomInnerShift;
        private final CTSpriteShiftEntry shift2x2;

        public OvenCTBehavior(CTSpriteShiftEntry layerShift, CTSpriteShiftEntry topShift, CTSpriteShiftEntry innerShift, CTSpriteShiftEntry bottom, CTSpriteShiftEntry bottomInner, CTSpriteShiftEntry shift2x2) {
            super(layerShift, topShift, innerShift);
            this.bottomShift = bottom;
            this.bottomInnerShift = bottomInner;
            this.shift2x2 = shift2x2;
        }

        public CTSpriteShiftEntry getShift(BlockState state, Direction direction, @Nullable TextureAtlasSprite sprite) {
            if (sprite != null && direction.getAxis() == Direction.Axis.Y && this.bottomShift.getOriginal() == sprite) {
                return this.bottomShift;
            }
            if (sprite != null && direction.getAxis() == Direction.Axis.Y && this.bottomInnerShift.getOriginal() == sprite) {
                return this.bottomInnerShift;
            }
            CTSpriteShiftEntry shift = super.getShift(state, direction, sprite);
            if (shift == CRSpriteShifts.OVEN_SPRITE && ((Boolean)state.getValue((Property)OvenBlock.IS_2x2)).booleanValue()) {
                return this.shift2x2;
            }
            return shift;
        }
    }

    private static class CullData {
        Map<Direction, Boolean> culledFaces = new HashMap<Direction, Boolean>();

        public CullData() {
            for (Direction d : Iterate.directions) {
                this.culledFaces.put(d, false);
            }
        }

        void setCulled(Direction face, boolean cull) {
            this.culledFaces.put(face, cull);
        }

        boolean isCulled(Direction face) {
            return this.culledFaces.get(face);
        }
    }

    public static class OvenGenerator
    extends FluidTankGenerator {
        protected ModelFile model = null;

        public <T extends Block> ModelFile getModel(DataGenContext<Block, T> ctx, RegistrateBlockstateProvider prov, BlockState state) {
            if (this.model != null) {
                return this.model;
            }
            this.model = prov.models().getExistingFile(prov.modLoc(ctx.getName()));
            return this.model;
        }
    }
}

